"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));

var _react = _interopRequireWildcard(require("react"));

var _Pagination = require("@patternfly/react-core/dist/js/components/Pagination/Pagination.js");

var _Bullseye = require("@patternfly/react-core/dist/js/layouts/Bullseye/Bullseye.js");

var _EmptyState = require("@patternfly/react-core/dist/js/components/EmptyState/EmptyState.js");

var _Title = require("@patternfly/react-core/dist/js/components/Title/Title.js");

var _EmptyStateBody = require("@patternfly/react-core/dist/js/components/EmptyState/EmptyStateBody.js");

var _propTypes = require("prop-types");

var _reactTable = require("@patternfly/react-table");

var _EmptyTable = require("../EmptyTable");

var _TableToolbar = require("../TableToolbar");

var _PrimaryToolbar = require("../PrimaryToolbar");

var _Skeleton = require("../Skeleton");

var _SkeletonTable = require("../SkeletonTable");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var TableWithFilter = function TableWithFilter(_ref) {
  var rows = _ref.rows,
      _onSelect = _ref.onSelect,
      selected = _ref.selected,
      onUpdateData = _ref.onUpdateData,
      pagination = _ref.pagination,
      loaded = _ref.loaded,
      calculateChecked = _ref.calculateChecked,
      unique = _ref.unique,
      filters = _ref.filters,
      primaryToolbarProps = _ref.primaryToolbarProps,
      children = _ref.children,
      title = _ref.title,
      systemName = _ref.systemName,
      columns = _ref.columns,
      tableProps = _ref.tableProps,
      entityName = _ref.entityName,
      bulkSelect = _ref.bulkSelect;

  var onRowSelect = function onRowSelect(_ref2) {
    var isSelected = _ref2.isSelected,
        rowId = _ref2.rowId;
    var currRow = rows === null || rows === void 0 ? void 0 : rows[rowId];

    if (currRow) {
      _onSelect(isSelected ? [].concat((0, _toConsumableArray2["default"])(selected), [currRow]) : selected.filter(function (_ref3) {
        var id = _ref3.id;
        return id !== currRow.id;
      }));
    }
  };

  return /*#__PURE__*/_react["default"].createElement(_react.Fragment, null, onUpdateData && /*#__PURE__*/_react["default"].createElement(_PrimaryToolbar.PrimaryToolbar, (0, _extends2["default"])({}, _onSelect && pagination && {
    bulkSelect: _objectSpread({
      count: selected === null || selected === void 0 ? void 0 : selected.length,
      onSelect: function onSelect(isSelected) {
        if (isSelected) {
          _onSelect(unique === null || unique === void 0 ? void 0 : unique([].concat((0, _toConsumableArray2["default"])(rows), (0, _toConsumableArray2["default"])(selected))));
        } else {
          _onSelect(selected.filter(function (_ref4) {
            var id = _ref4.id;
            return !rows.find(function (_ref5) {
              var rowId = _ref5.id;
              return rowId === id;
            });
          }));
        }
      },
      checked: loaded && (calculateChecked === null || calculateChecked === void 0 ? void 0 : calculateChecked(rows, selected)),
      items: [{
        title: 'Select none (0)',
        onClick: function onClick() {
          return _onSelect([]);
        }
      }, _objectSpread({}, loaded && (rows === null || rows === void 0 ? void 0 : rows.length) > 0 ? {
        title: "Select page (".concat(rows.length, ")"),
        onClick: function onClick() {
          return _onSelect(unique([].concat((0, _toConsumableArray2["default"])(rows), (0, _toConsumableArray2["default"])(selected))));
        }
      } : {})]
    }, bulkSelect || {})
  }, filters && {
    filterConfig: {
      items: filters
    }
  }, {
    pagination: loaded ? _objectSpread(_objectSpread({}, pagination || {}), {}, {
      itemCount: pagination === null || pagination === void 0 ? void 0 : pagination.count,
      onSetPage: function onSetPage(_e, page) {
        return onUpdateData(_objectSpread(_objectSpread({}, pagination), {}, {
          page: page
        }));
      },
      onPerPageSelect: function onPerPageSelect(_e, perPage) {
        return onUpdateData(_objectSpread(_objectSpread({}, pagination), {}, {
          page: 1,
          perPage: perPage
        }));
      }
    }) : /*#__PURE__*/_react["default"].createElement(_Skeleton.Skeleton, {
      size: "lg"
    })
  }, primaryToolbarProps)), children, loaded ? /*#__PURE__*/_react["default"].createElement(_reactTable.Table, (0, _extends2["default"])({
    "aria-label": title || "".concat(systemName, " ").concat(entityName),
    variant: "compact",
    className: "ins-c-tag-modal__table",
    cells: columns,
    rows: rows !== null && rows !== void 0 && rows.length ? rows : [{
      cells: [{
        title: /*#__PURE__*/_react["default"].createElement(_EmptyTable.EmptyTable, null, /*#__PURE__*/_react["default"].createElement(_Bullseye.Bullseye, null, /*#__PURE__*/_react["default"].createElement(_EmptyState.EmptyState, {
          variant: _EmptyState.EmptyStateVariant.full
        }, /*#__PURE__*/_react["default"].createElement(_Title.Title, {
          headingLevel: "h5",
          size: "lg"
        }, "No ", entityName, " found"), /*#__PURE__*/_react["default"].createElement(_EmptyStateBody.EmptyStateBody, null, "This filter criteria matches no ", entityName, ". ", /*#__PURE__*/_react["default"].createElement("br", null), " Try changing your filter settings.")))),
        props: {
          colSpan: columns.length
        }
      }]
    }]
  }, _onSelect && (rows === null || rows === void 0 ? void 0 : rows.length) && {
    onSelect: function onSelect(_event, isSelected, rowId) {
      return onRowSelect({
        isSelected: isSelected,
        rowId: rowId
      });
    }
  }, tableProps), /*#__PURE__*/_react["default"].createElement(_reactTable.TableHeader, null), /*#__PURE__*/_react["default"].createElement(_reactTable.TableBody, null)) : /*#__PURE__*/_react["default"].createElement(_SkeletonTable.SkeletonTable, {
    columns: columns,
    rowSize: (pagination === null || pagination === void 0 ? void 0 : pagination.perPage) || 10
  }), onUpdateData && pagination && loaded && /*#__PURE__*/_react["default"].createElement(_TableToolbar.TableToolbar, {
    isFooter: true,
    className: "ins-c-inventory__table--toolbar"
  }, /*#__PURE__*/_react["default"].createElement(_Pagination.Pagination, {
    itemCount: pagination === null || pagination === void 0 ? void 0 : pagination.count,
    perPage: pagination === null || pagination === void 0 ? void 0 : pagination.perPage,
    page: (pagination === null || pagination === void 0 ? void 0 : pagination.page) || 0,
    variant: "bottom",
    onSetPage: function onSetPage(_event, page) {
      return onUpdateData(_objectSpread(_objectSpread({}, pagination), {}, {
        page: page
      }));
    },
    onPerPageSelect: function onPerPageSelect(_event, perPage) {
      return onUpdateData(_objectSpread(_objectSpread({}, pagination), {}, {
        page: 1,
        perPage: perPage
      }));
    }
  })));
};

TableWithFilter.propTypes = {
  entityName: _propTypes.PropTypes.string,
  loaded: _propTypes.PropTypes.bool,
  systemName: _propTypes.PropTypes.string,
  rows: _propTypes.PropTypes.array,
  selected: _propTypes.PropTypes.array,
  columns: _propTypes.PropTypes.array,
  filters: _propTypes.PropTypes.array,
  pagination: _propTypes.PropTypes.shape({
    count: _propTypes.PropTypes.number,
    page: _propTypes.PropTypes.number,
    perPage: _propTypes.PropTypes.number
  }),
  primaryToolbarProps: _propTypes.PropTypes.object,
  tableProps: _propTypes.PropTypes.object,
  children: _propTypes.PropTypes.node,
  title: _propTypes.PropTypes.node,
  calculateChecked: _propTypes.PropTypes.func,
  unique: _propTypes.PropTypes.func,
  onSelect: _propTypes.PropTypes.func,
  onUpdateData: _propTypes.PropTypes.func,
  bulkSelect: _propTypes.PropTypes.any
};
TableWithFilter.defaultProps = {
  entityName: 'tags'
};
var _default = TableWithFilter;
exports["default"] = _default;