import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _extends from "@babel/runtime/helpers/extends";
import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _assertThisInitialized from "@babel/runtime/helpers/assertThisInitialized";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _defineProperty from "@babel/runtime/helpers/defineProperty";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

import React, { Component, Fragment } from 'react';
import PropTypes from 'prop-types';
import { Select } from "@patternfly/react-core/dist/esm/components/Select/Select.js";
import { SelectOption } from "@patternfly/react-core/dist/esm/components/Select/SelectOption.js";
import { SelectVariant } from "@patternfly/react-core/dist/esm/components/Select/selectConstants.js";
import Text from './TextFilter';
import isEqual from 'lodash/isEqual';
/**
 * CheckboxFilter is a part of the <a href="/components/ConditionalFilter">Conditional filter composite component</a>.
 * It was not designed to be used as a standalone component.
 */

var CheckboxFilter = /*#__PURE__*/function (_Component) {
  _inherits(CheckboxFilter, _Component);

  var _super = _createSuper(CheckboxFilter);

  function CheckboxFilter() {
    var _this;

    _classCallCheck(this, CheckboxFilter);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    _defineProperty(_assertThisInitialized(_this), "state", {
      isExpanded: false,
      selected: []
    });

    _defineProperty(_assertThisInitialized(_this), "onToggle", function (isExpanded) {
      _this.setState({
        isExpanded: isExpanded
      });
    });

    _defineProperty(_assertThisInitialized(_this), "calculateSelected", function () {
      var selected = _this.state.selected;
      var value = _this.props.value;
      return Array.from(new Set([].concat(_toConsumableArray(value && value.length > 0 && value.constructor === Array ? value.map(function (item) {
        return item.value || item;
      }) : []), _toConsumableArray(selected))));
    });

    _defineProperty(_assertThisInitialized(_this), "onSelect", function (event, selection) {
      var onChange = _this.props.onChange;

      var newSelection = _this.calculateSelected();

      if (newSelection.includes(selection)) {
        newSelection = newSelection.filter(function (item) {
          return item !== selection;
        });
      } else {
        newSelection = [].concat(_toConsumableArray(newSelection), [selection]);
      }

      onChange(event, newSelection, selection);

      _this.setState({
        selected: newSelection
      });
    });

    return _this;
  }

  _createClass(CheckboxFilter, [{
    key: "componentDidUpdate",
    value: function componentDidUpdate(_ref) {
      var prevSelected = _ref.value;
      var value = this.props.value;

      if (!isEqual(prevSelected, value)) {
        this.setState({
          selected: value
        });
      }
    }
  }, {
    key: "render",
    value: function render() {
      var isExpanded = this.state.isExpanded;
      var _this$props = this.props,
          items = _this$props.items,
          placeholder = _this$props.placeholder,
          isDisabled = _this$props.isDisabled,
          className = _this$props.className;
      return /*#__PURE__*/React.createElement(Fragment, null, !items || items && items.length <= 0 ? /*#__PURE__*/React.createElement(Text, _extends({}, this.props, {
        value: "".concat(this.calculateSelected())
      })) : /*#__PURE__*/React.createElement(Select, {
        className: className,
        variant: SelectVariant.checkbox,
        "aria-label": "Select Input",
        onToggle: this.onToggle,
        isDisabled: isDisabled,
        onSelect: this.onSelect,
        selections: this.calculateSelected(),
        isOpen: isExpanded,
        placeholderText: placeholder,
        ouiaId: placeholder
      }, items.map(function (_ref2, key) {
        var value = _ref2.value,
            _onClick = _ref2.onClick,
            label = _ref2.label,
            id = _ref2.id,
            item = _objectWithoutProperties(_ref2, ["value", "onClick", "label", "id"]);

        return /*#__PURE__*/React.createElement(SelectOption, _extends({}, item, {
          key: id || key,
          value: String(value || id || key),
          onClick: function onClick(e) {
            return _onClick && _onClick(e, _objectSpread({
              value: value,
              label: label,
              id: id
            }, item), key);
          }
        }), label);
      })));
    }
  }]);

  return CheckboxFilter;
}(Component);

CheckboxFilter.propTypes = {
  /**
   * onChange event callback <br /><code>func(event, newSelection, currentSelection) => undefined</code>
   */
  onChange: PropTypes.func,

  /**
   * List of selected values
   */
  value: PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.string, PropTypes.shape({
    label: PropTypes.node,
    value: PropTypes.string
  })])),

  /**
   * Select value placeholder
   */
  placeholder: PropTypes.string,

  /**
   * List of available options
   */
  items: PropTypes.arrayOf(PropTypes.shape({
    value: PropTypes.string,
    label: PropTypes.node,
    id: PropTypes.string,
    onClick: PropTypes.func
  })),

  /**
   * Disabled flag
   */
  isDisabled: PropTypes.bool,
  className: PropTypes.string
};
CheckboxFilter.defaultProps = {
  items: [],
  value: [],
  onChange: function onChange() {
    return undefined;
  },
  isDisabled: false
};
export default CheckboxFilter;