import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _assertThisInitialized from "@babel/runtime/helpers/assertThisInitialized";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _defineProperty from "@babel/runtime/helpers/defineProperty";

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

import React, { Component, Fragment } from 'react';
import PropTypes from 'prop-types';
import { TextInput } from "@patternfly/react-core/dist/esm/components/TextInput/TextInput.js";
import SearchIcon from "@patternfly/react-icons/dist/esm/icons/search-icon";
import "../../ConditionalFilter/./conditional-filter.css";

var Text = /*#__PURE__*/function (_Component) {
  _inherits(Text, _Component);

  var _super = _createSuper(Text);

  function Text() {
    var _this;

    _classCallCheck(this, Text);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    _defineProperty(_assertThisInitialized(_this), "state", {
      stateValue: ''
    });

    _defineProperty(_assertThisInitialized(_this), "onChangeValue", function (e, value) {
      _this.setState({
        stateValue: value
      });
    });

    return _this;
  }

  _createClass(Text, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          value = _this$props.value,
          onChange = _this$props.onChange,
          onSubmit = _this$props.onSubmit,
          id = _this$props.id,
          icon = _this$props.icon,
          className = _this$props.className,
          isDisabled = _this$props.isDisabled,
          props = _objectWithoutProperties(_this$props, ["value", "onChange", "onSubmit", "id", "icon", "className", "isDisabled"]);

      var Icon = icon || SearchIcon;
      var stateValue = this.state.stateValue;
      var changeCallback = onChange ? onChange : this.onChangeValue;
      return /*#__PURE__*/React.createElement(Fragment, null, /*#__PURE__*/React.createElement(TextInput, _extends({}, props, {
        className: "ins-c-conditional-filter ".concat(className || ''),
        id: id,
        isDisabled: isDisabled,
        value: onChange ? value : stateValue,
        onChange: function onChange(_inputValue, e) {
          return changeCallback(e, e.target.value);
        },
        "widget-type": "InsightsInput",
        onKeyDown: function onKeyDown(e) {
          return e.key === 'Enter' && onSubmit(e, value || stateValue);
        },
        "data-ouia-component-type": "PF4/TextInput",
        ouiaId: "ConditionalFilter"
      })), /*#__PURE__*/React.createElement(Icon, {
        size: "sm",
        className: "ins-c-search-icon"
      }));
    }
  }]);

  return Text;
}(Component);

Text.propTypes = {
  value: PropTypes.string,
  placeholder: PropTypes.string,
  onChange: PropTypes.func,
  onSubmit: PropTypes.func,
  isDisabled: PropTypes.bool,
  'aria-label': PropTypes.string,
  id: PropTypes.string,
  icon: PropTypes.elementType,
  className: PropTypes.string
};
Text.defaultProps = {
  value: '',
  onSubmit: function onSubmit() {
    return undefined;
  },
  isDisabled: false,
  'aria-label': 'text input'
};
export default Text;