import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _assertThisInitialized from "@babel/runtime/helpers/assertThisInitialized";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _defineProperty from "@babel/runtime/helpers/defineProperty";

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

import React, { Component } from 'react';
import PropTypes from 'prop-types';
import CaretDownIcon from "@patternfly/react-icons/dist/esm/icons/caret-down-icon";
import CaretUpIcon from "@patternfly/react-icons/dist/esm/icons/caret-up-icon";
import CheckIcon from "@patternfly/react-icons/dist/esm/icons/check-icon";
import { Dropdown } from "@patternfly/react-core/dist/esm/components/Dropdown/Dropdown.js";
import { DropdownItem } from "@patternfly/react-core/dist/esm/components/Dropdown/DropdownItem.js";
import { DropdownToggle } from "@patternfly/react-core/dist/esm/components/Dropdown/DropdownToggle.js";

var PaginationNav = /*#__PURE__*/function (_Component) {
  _inherits(PaginationNav, _Component);

  var _super = _createSuper(PaginationNav);

  function PaginationNav() {
    var _this;

    _classCallCheck(this, PaginationNav);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    _defineProperty(_assertThisInitialized(_this), "state", {
      isOpen: false
    });

    _defineProperty(_assertThisInitialized(_this), "onSelect", function () {
      _this.setState({
        isOpen: !_this.state.isOpen
      });
    });

    _defineProperty(_assertThisInitialized(_this), "onToggle", function (isOpen) {
      _this.setState({
        isOpen: isOpen
      });
    });

    return _this;
  }

  _createClass(PaginationNav, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          itemsTitle = _this$props.itemsTitle,
          itemsStart = _this$props.itemsStart,
          itemsEnd = _this$props.itemsEnd,
          widtgetId = _this$props.widtgetId,
          dropDirection = _this$props.dropDirection,
          onSetPerPage = _this$props.onSetPerPage,
          itemCount = _this$props.itemCount,
          perPageOptions = _this$props.perPageOptions,
          className = _this$props.className,
          perPage = _this$props.perPage,
          props = _objectWithoutProperties(_this$props, ["itemsTitle", "itemsStart", "itemsEnd", "widtgetId", "dropDirection", "onSetPerPage", "itemCount", "perPageOptions", "className", "perPage"]);

      var isOpen = this.state.isOpen;
      return /*#__PURE__*/React.createElement("div", _extends({
        className: "pf-c-options-menu ".concat(className)
      }, props), /*#__PURE__*/React.createElement("span", {
        id: "".concat(widtgetId, "-label"),
        hidden: true
      }, "Items per page:"), /*#__PURE__*/React.createElement("div", {
        className: "pf-c-options-menu__toggle pf-m-text pf-m-plain"
      }, /*#__PURE__*/React.createElement(Dropdown, {
        direction: dropDirection,
        isPlain: true,
        isOpen: isOpen,
        onSelect: this.onSelect,
        dropdownItems: perPageOptions.map(function (_ref) {
          var title = _ref.title,
              value = _ref.value;
          return /*#__PURE__*/React.createElement(DropdownItem, {
            onClick: function onClick(event) {
              return value !== perPage && onSetPerPage(event, value);
            },
            key: value,
            component: "button"
          }, title, value === perPage && /*#__PURE__*/React.createElement(CheckIcon, {
            className: "pf-c-options-menu__menu-item-icon",
            size: "md"
          }));
        }),
        toggle: /*#__PURE__*/React.createElement(DropdownToggle, {
          onToggle: this.onToggle,
          toggleIndicator: null,
          className: "pf-c-options-menu__toggle-button"
        }, /*#__PURE__*/React.createElement("span", {
          className: "pf-c-options-menu__toggle-text"
        }, /*#__PURE__*/React.createElement("b", null, itemsStart, " - ", itemsEnd), " of ", /*#__PURE__*/React.createElement("b", null, itemCount), " ", itemsTitle), dropDirection === 'up' ? /*#__PURE__*/React.createElement(CaretUpIcon, null) : /*#__PURE__*/React.createElement(CaretDownIcon, null))
      })));
    }
  }]);

  return PaginationNav;
}(Component);

PaginationNav.propTypes = {
  itemsTitle: PropTypes.string,
  itemsStart: PropTypes.number,
  itemsEnd: PropTypes.number,
  dropDirection: PropTypes.string,
  widtgetId: PropTypes.string,
  onSetPerPage: PropTypes.func,
  itemCount: PropTypes.number.isRequired,
  perPage: PropTypes.number,
  perPageOptions: PropTypes.arrayOf(PropTypes.shape({
    title: PropTypes.node,
    value: PropTypes.number
  })),
  className: PropTypes.string
};
PaginationNav.defaultProps = {
  itemsTitle: 'items',
  dropDirection: 'up',
  className: ''
};
export default PaginationNav;