"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _react = require("react");

var _getVariant = _interopRequireDefault(require("./getVariant"));

var useScreen = function useScreen() {
  var _useState = (0, _react.useState)(function () {
    return (0, _getVariant["default"])();
  }),
      _useState2 = (0, _slicedToArray2["default"])(_useState, 2),
      variant = _useState2[0],
      setVariant = _useState2[1];

  var prev = (0, _react.useRef)(variant);
  (0, _react.useEffect)(function () {
    function handleResize() {
      var newVariant = (0, _getVariant["default"])();

      if (newVariant !== prev.current) {
        prev.current = newVariant;
        setVariant(newVariant);
      }
    }

    window.addEventListener('resize', handleResize);
    return function () {
      return window.removeEventListener('resize', handleResize);
    };
  }, []);
  return variant;
};

var _default = useScreen;
exports["default"] = _default;