"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const experimental_utils_1 = require("@typescript-eslint/experimental-utils");
const no_restricted_imports_1 = __importDefault(require("eslint/lib/rules/no-restricted-imports"));
const ignore_1 = __importDefault(require("ignore"));
const util_1 = require("../util");
const allowTypeImportsOptionSchema = {
    allowTypeImports: {
        type: 'boolean',
        default: false,
    },
};
const schemaForMergeArrayOfStringsOrObjects = {
    items: {
        anyOf: [
            {},
            {
                properties: allowTypeImportsOptionSchema,
            },
        ],
    },
};
const schemaForMergeArrayOfStringsOrObjectPatterns = {
    anyOf: [
        {},
        {
            items: {
                properties: allowTypeImportsOptionSchema,
            },
        },
    ],
};
const schema = (0, util_1.deepMerge)(Object.assign({}, no_restricted_imports_1.default.meta.schema), {
    anyOf: [
        schemaForMergeArrayOfStringsOrObjects,
        {
            items: {
                properties: {
                    paths: schemaForMergeArrayOfStringsOrObjects,
                    patterns: schemaForMergeArrayOfStringsOrObjectPatterns,
                },
            },
        },
    ],
});
function isObjectOfPaths(obj) {
    return Object.prototype.hasOwnProperty.call(obj, 'paths');
}
function isObjectOfPatterns(obj) {
    return Object.prototype.hasOwnProperty.call(obj, 'patterns');
}
function isOptionsArrayOfStringOrObject(options) {
    if (isObjectOfPaths(options[0])) {
        return false;
    }
    if (isObjectOfPatterns(options[0])) {
        return false;
    }
    return true;
}
function getRestrictedPaths(options) {
    if (isOptionsArrayOfStringOrObject(options)) {
        return options;
    }
    if (isObjectOfPaths(options[0])) {
        return options[0].paths;
    }
    return [];
}
function getRestrictedPatterns(options) {
    if (isObjectOfPatterns(options[0])) {
        return options[0].patterns;
    }
    return [];
}
exports.default = (0, util_1.createRule)({
    name: 'no-restricted-imports',
    meta: {
        type: 'suggestion',
        docs: {
            description: 'Disallow specified modules when loaded by `import`',
            category: 'Best Practices',
            recommended: false,
            extendsBaseRule: true,
        },
        messages: no_restricted_imports_1.default.meta.messages,
        fixable: no_restricted_imports_1.default.meta.fixable,
        schema,
    },
    defaultOptions: [],
    create(context) {
        const rules = no_restricted_imports_1.default.create(context);
        const { options } = context;
        if (options.length === 0) {
            return {};
        }
        const restrictedPaths = getRestrictedPaths(options);
        const allowedTypeImportPathNameSet = new Set();
        for (const restrictedPath of restrictedPaths) {
            if (typeof restrictedPath === 'object' &&
                restrictedPath.allowTypeImports) {
                allowedTypeImportPathNameSet.add(restrictedPath.name);
            }
        }
        function isAllowedTypeImportPath(importSource) {
            return allowedTypeImportPathNameSet.has(importSource);
        }
        const restrictedPatterns = getRestrictedPatterns(options);
        const allowedImportTypeMatchers = [];
        for (const restrictedPattern of restrictedPatterns) {
            if (typeof restrictedPattern === 'object' &&
                restrictedPattern.allowTypeImports) {
                allowedImportTypeMatchers.push((0, ignore_1.default)().add(restrictedPattern.group));
            }
        }
        function isAllowedTypeImportPattern(importSource) {
            return allowedImportTypeMatchers.every(matcher => {
                return matcher.ignores(importSource);
            });
        }
        return {
            ImportDeclaration(node) {
                if (typeof node.source.value !== 'string') {
                    return;
                }
                if (node.importKind === 'type') {
                    const importSource = node.source.value.trim();
                    if (!isAllowedTypeImportPath(importSource) &&
                        !isAllowedTypeImportPattern(importSource)) {
                        return rules.ImportDeclaration(node);
                    }
                }
                else {
                    return rules.ImportDeclaration(node);
                }
            },
            ExportNamedDeclaration(node) {
                var _a;
                if (((_a = node.source) === null || _a === void 0 ? void 0 : _a.type) !== experimental_utils_1.AST_NODE_TYPES.Literal ||
                    typeof node.source.value !== 'string') {
                    return;
                }
                if (node.exportKind === 'type') {
                    const importSource = node.source.value.trim();
                    if (!isAllowedTypeImportPath(importSource) &&
                        !isAllowedTypeImportPattern(importSource)) {
                        return rules.ExportNamedDeclaration(node);
                    }
                }
                else {
                    return rules.ExportNamedDeclaration(node);
                }
            },
            ExportAllDeclaration: rules.ExportAllDeclaration,
        };
    },
});
//# sourceMappingURL=no-restricted-imports.js.map