"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getBulletThemeWithLegendColorScale = exports.getColorScale = void 0;
const chart_bullet_data_1 = require("./chart-bullet-data");
const ChartUtils_1 = require("../../ChartUtils");
const getLegendColorScale = (computedData, legendData) => {
    const colorScale = [];
    legendData.forEach((data, index) => {
        for (const i of computedData) {
            if (index === i._index) {
                colorScale.push(i._color);
            }
        }
    });
    return colorScale;
};
const getColorScale = ({ comparativeErrorMeasureData, comparativeErrorMeasureLegendData, comparativeWarningMeasureData, comparativeWarningMeasureLegendData, invert, primaryDotMeasureData, primaryDotMeasureLegendData, primarySegmentedMeasureData, primarySegmentedMeasureLegendData, qualitativeRangeData, qualitativeRangeLegendData, themeColor, themeVariant }) => {
    const colorScale = [];
    if (primaryDotMeasureLegendData && primaryDotMeasureLegendData.length) {
        const computedData = chart_bullet_data_1.getPrimaryDotMeasureData({
            data: primaryDotMeasureData,
            invert
        });
        colorScale.push(...getLegendColorScale(computedData, primaryDotMeasureLegendData));
    }
    if (primarySegmentedMeasureLegendData && primarySegmentedMeasureLegendData.length) {
        const computedData = chart_bullet_data_1.getPrimarySegmentedMeasureData({
            data: primarySegmentedMeasureData,
            invert,
            themeColor,
            themeVariant
        });
        colorScale.push(...getLegendColorScale(computedData, primarySegmentedMeasureLegendData));
    }
    if (comparativeWarningMeasureLegendData && comparativeWarningMeasureLegendData.length) {
        const computedData = chart_bullet_data_1.getComparativeWarningMeasureData({
            data: comparativeWarningMeasureData,
            invert,
            themeColor,
            themeVariant
        });
        colorScale.push(...getLegendColorScale(computedData, comparativeWarningMeasureLegendData));
    }
    if (comparativeErrorMeasureLegendData && comparativeErrorMeasureLegendData.length) {
        const computedData = chart_bullet_data_1.getComparativeErrorMeasureData({
            data: comparativeErrorMeasureData,
            invert,
            themeColor,
            themeVariant
        });
        colorScale.push(...getLegendColorScale(computedData, comparativeErrorMeasureLegendData));
    }
    if (qualitativeRangeLegendData && qualitativeRangeLegendData.length) {
        const computedData = chart_bullet_data_1.getQualitativeRangeData({
            data: qualitativeRangeData,
            invert
        });
        colorScale.push(...getLegendColorScale(computedData, qualitativeRangeLegendData));
    }
    return colorScale;
};
exports.getColorScale = getColorScale;
// Get bullet chart theme with legend color scale
const getBulletThemeWithLegendColorScale = ({ comparativeErrorMeasureData, comparativeErrorMeasureLegendData, comparativeWarningMeasureData, comparativeWarningMeasureLegendData, invert, primaryDotMeasureData, primaryDotMeasureLegendData, primarySegmentedMeasureData, primarySegmentedMeasureLegendData, qualitativeRangeData, qualitativeRangeLegendData, themeColor, themeVariant }) => {
    const colorScale = exports.getColorScale({
        comparativeErrorMeasureData,
        comparativeErrorMeasureLegendData,
        comparativeWarningMeasureData,
        comparativeWarningMeasureLegendData,
        invert,
        primaryDotMeasureData,
        primaryDotMeasureLegendData,
        primarySegmentedMeasureData,
        primarySegmentedMeasureLegendData,
        qualitativeRangeData,
        qualitativeRangeLegendData,
        themeColor,
        themeVariant
    });
    const theme = ChartUtils_1.getBulletTheme(themeColor, themeVariant);
    theme.legend.colorScale = [...colorScale];
    return theme;
};
exports.getBulletThemeWithLegendColorScale = getBulletThemeWithLegendColorScale;
//# sourceMappingURL=chart-bullet-theme.js.map