"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = _interopRequireWildcard(require("react"));

var _Dropdown = require("@patternfly/react-core/dist/js/components/Dropdown/Dropdown.js");

var _DropdownItem = require("@patternfly/react-core/dist/js/components/Dropdown/DropdownItem.js");

var _DropdownToggle = require("@patternfly/react-core/dist/js/components/Dropdown/DropdownToggle.js");

var _SplitItem = require("@patternfly/react-core/dist/js/layouts/Split/SplitItem.js");

var _Split = require("@patternfly/react-core/dist/js/layouts/Split/Split.js");

var _ToolbarItem = require("@patternfly/react-core/dist/js/components/Toolbar/ToolbarItem.js");

var _ToolbarGroup = require("@patternfly/react-core/dist/js/components/Toolbar/ToolbarGroup.js");

var _ToolbarToggleGroup = require("@patternfly/react-core/dist/js/components/Toolbar/ToolbarToggleGroup.js");

var _filterIcon = _interopRequireDefault(require("@patternfly/react-icons/dist/js/icons/filter-icon"));

var _global_breakpoint_md = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/global_breakpoint_md"));

var _TextFilter = _interopRequireDefault(require("./TextFilter"));

var _conditionalFilterConstants = require("./conditionalFilterConstants");

var _propTypes = _interopRequireDefault(require("prop-types"));

require("./conditional-filter.css");

var _classnames = _interopRequireDefault(require("classnames"));

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var ConditionalFilter = /*#__PURE__*/function (_Component) {
  (0, _inherits2["default"])(ConditionalFilter, _Component);

  var _super = _createSuper(ConditionalFilter);

  function ConditionalFilter(_props) {
    var _this;

    (0, _classCallCheck2["default"])(this, ConditionalFilter);

    if (!_props.useMobileLayout) {
      console.warn("The prop \"useMobileLayout\" is set to false. You are using an outdated mobile layout of conditional filter.\n            Please switch to new layout by adding \"useMobileLayout={true}\" prop to the PrimaryToolbar or ConditionalFilter directly.\n            The new mobile layout will become the default in next minor release.");
    }

    _this = _super.call(this, _props);
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "dropdownToggle", function (isOpen) {
      _this.setState({
        isOpen: isOpen
      });
    });
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "onChange", function (_e, value) {
      _this.setState({
        stateValue: value
      });
    });
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "getWrapper", function () {
      return _this.props.useMobileLayout && _this.state.isMobile ? function (props) {
        return /*#__PURE__*/_react["default"].createElement(_ToolbarToggleGroup.ToolbarToggleGroup, (0, _extends2["default"])({}, props, {
          breakpoint: "md",
          toggleIcon: /*#__PURE__*/_react["default"].createElement(_filterIcon["default"], null)
        }));
      } : _react.Fragment;
    });
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "updateFilterViewport", function (width) {
      return width <= _this.breakpointConstant;
    });
    _this.breakpointConstant = parseInt(_global_breakpoint_md["default"].value.replace('px', ''));
    _this.state = {
      isOpen: false,
      stateValue: undefined,
      isMobile: _this.updateFilterViewport(window.innerWidth)
    };
    return _this;
  }

  (0, _createClass2["default"])(ConditionalFilter, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this2 = this;

      this.resizeListener = window.addEventListener('resize', function (event) {
        _this2.setState(function (prev) {
          return _objectSpread(_objectSpread({}, prev), {}, {
            isMobile: _this2.updateFilterViewport(event.target.innerWidth)
          });
        });
      });
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      if (this.resizeListener) {
        window.removeEventListener(this.resizeListener);
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this3 = this;

      var _this$props = this.props,
          items = _this$props.items,
          value = _this$props.value,
          onChange = _this$props.onChange,
          placeholder = _this$props.placeholder,
          hideLabel = _this$props.hideLabel,
          isDisabled = _this$props.isDisabled,
          props = (0, _objectWithoutProperties2["default"])(_this$props, ["items", "value", "onChange", "placeholder", "hideLabel", "isDisabled"]);
      var _this$state = this.state,
          isOpen = _this$state.isOpen,
          stateValue = _this$state.stateValue,
          isMobile = _this$state.isMobile;
      var currentValue = onChange ? value : stateValue;
      var activeItem = items && items.length && (items.find(function (item, key) {
        return item.value === currentValue || key === currentValue;
      }) || items[0]);
      var onChangeCallback = onChange || this.onChange;
      var ActiveComponent = activeItem && (_conditionalFilterConstants.typeMapper[activeItem.type] || _conditionalFilterConstants.typeMapper.text);

      var capitalize = function capitalize(string) {
        return string[0].toUpperCase() + string.substring(1);
      };

      var shouldRenderNewLayout = this.props.useMobileLayout && isMobile;
      var Wrapper = this.getWrapper();
      return /*#__PURE__*/_react["default"].createElement(Wrapper, null, this.props.useMobileLayout && isMobile && /*#__PURE__*/_react["default"].createElement(_ToolbarGroup.ToolbarGroup, {
        className: "ins-c-conditional-filter mobile"
      }, items.map(function (activeItem, key) {
        var ActiveComponent = activeItem && (_conditionalFilterConstants.typeMapper[activeItem.type] || _conditionalFilterConstants.typeMapper.text);
        return /*#__PURE__*/_react["default"].createElement(_ToolbarItem.ToolbarItem, {
          key: key
        }, /*#__PURE__*/_react["default"].createElement(ActiveComponent, (0, _extends2["default"])({}, activeItem.type !== _conditionalFilterConstants.conditionalFilterType.custom && {
          placeholder: placeholder || activeItem.placeholder || "Filter by ".concat(activeItem.label),
          id: activeItem.filterValues && activeItem.filterValues.id || currentValue
        }, activeItem.filterValues)));
      })), !shouldRenderNewLayout && /*#__PURE__*/_react["default"].createElement(_react.Fragment, null, !items || items && items.length <= 0 ? /*#__PURE__*/_react["default"].createElement("div", {
        className: (0, _classnames["default"])('ins-c-conditional-filter', {
          desktop: this.props.useMobileLayout
        })
      }, /*#__PURE__*/_react["default"].createElement(_TextFilter["default"], (0, _extends2["default"])({}, props, {
        value: currentValue,
        onChange: function onChange(e) {
          return onChangeCallback(e, e.target.value);
        },
        placeholder: placeholder,
        "widget-type": "InsightsInput"
      }))) : /*#__PURE__*/_react["default"].createElement(_Split.Split, {
        className: (0, _classnames["default"])('ins-c-conditional-filter', {
          desktop: this.props.useMobileLayout
        })
      }, items.length > 1 && /*#__PURE__*/_react["default"].createElement(_SplitItem.SplitItem, null, /*#__PURE__*/_react["default"].createElement(_Dropdown.Dropdown, {
        className: "ins-c-conditional-filter__group",
        onSelect: function onSelect() {
          return _this3.dropdownToggle(false);
        },
        isOpen: isOpen,
        ouiaId: "ConditionalFilter",
        toggle: /*#__PURE__*/_react["default"].createElement(_DropdownToggle.DropdownToggle, {
          onToggle: this.dropdownToggle,
          isDisabled: isDisabled,
          className: hideLabel ? 'ins-c-conditional-filter__no-label' : '',
          ouiaId: "ConditionalFilter"
        }, /*#__PURE__*/_react["default"].createElement(_filterIcon["default"], {
          size: "sm"
        }), !hideLabel && /*#__PURE__*/_react["default"].createElement("span", {
          className: "ins-c-conditional-filter__value-selector"
        }, activeItem && capitalize(activeItem.label))),
        dropdownItems: items.map(function (item, key) {
          return /*#__PURE__*/_react["default"].createElement(_DropdownItem.DropdownItem, {
            key: item.id ? "".concat(item.id, "-dropdown") : key,
            component: "button",
            ouiaId: item.label,
            onClick: function onClick(e) {
              return onChangeCallback(e, item.value || key, item);
            },
            isHovered: activeItem.label === item.label
          }, capitalize(item.label));
        })
      })), ActiveComponent && /*#__PURE__*/_react["default"].createElement(_SplitItem.SplitItem, {
        isFilled: true
      }, /*#__PURE__*/_react["default"].createElement(ActiveComponent, (0, _extends2["default"])({}, activeItem.type !== _conditionalFilterConstants.conditionalFilterType.custom && {
        placeholder: placeholder || activeItem.placeholder || "Filter by ".concat(activeItem.label),
        id: activeItem.filterValues && activeItem.filterValues.id || currentValue
      }, activeItem.filterValues))))));
    }
  }]);
  return ConditionalFilter;
}(_react.Component);

var TextInputProps = {
  value: _propTypes["default"].string,
  placeholder: _propTypes["default"].string,
  onChange: _propTypes["default"].func
};
ConditionalFilter.propTypes = _objectSpread(_objectSpread({
  hideLabel: _propTypes["default"].bool,
  items: _propTypes["default"].arrayOf(_propTypes["default"].shape({
    id: _propTypes["default"].string,
    label: _propTypes["default"].node,
    value: _propTypes["default"].string,
    type: _propTypes["default"].oneOf(['text', 'checkbox', 'radio', 'custom', 'group']),
    filterValues: _propTypes["default"].oneOfType([_propTypes["default"].shape(TextInputProps), _propTypes["default"].shape(_objectSpread(_objectSpread({}, TextInputProps), {}, {
      value: _propTypes["default"].oneOfType([_propTypes["default"].string, _propTypes["default"].arrayOf(_propTypes["default"].oneOfType([_propTypes["default"].string, _propTypes["default"].shape({
        label: _propTypes["default"].node,
        value: _propTypes["default"].string
      })])), _propTypes["default"].shape((0, _defineProperty2["default"])({}, _propTypes["default"].string, _propTypes["default"].any))]),
      items: _propTypes["default"].arrayOf(_propTypes["default"].shape({
        label: _propTypes["default"].node,
        value: _propTypes["default"].string
      }))
    }))])
  }))
}, TextInputProps), {}, {
  id: _propTypes["default"].string,
  isDisabled: _propTypes["default"].bool,
  useMobileLayout: _propTypes["default"].bool
});
ConditionalFilter.defaultProps = {
  value: '',
  items: [],
  hideLabel: false,
  isDisabled: false,
  id: 'default-input',
  useMobileLayout: false
};
var _default = ConditionalFilter;
exports["default"] = _default;