import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _defineProperty from "@babel/runtime/helpers/defineProperty";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

import groupType from './groupType';
export var isChecked = function isChecked(groupValue, itemValue, id, tagValue, stateSelected, propSelected) {
  var selected = _objectSpread(_objectSpread({}, propSelected), stateSelected);

  if (typeof selected[groupValue] === 'undefined') {
    return false;
  }

  if (selected[groupValue][itemValue] instanceof Object) {
    if (selected[groupValue][itemValue].isSelected) {
      var _selected$groupValue$, _selected$groupValue$2, _selected$groupValue$5, _selected$groupValue$6;

      if ((_selected$groupValue$ = selected[groupValue][itemValue]) !== null && _selected$groupValue$ !== void 0 && (_selected$groupValue$2 = _selected$groupValue$.item) !== null && _selected$groupValue$2 !== void 0 && _selected$groupValue$2.id) {
        var _selected$groupValue$3, _selected$groupValue$4;

        return id === ((_selected$groupValue$3 = selected[groupValue][itemValue]) === null || _selected$groupValue$3 === void 0 ? void 0 : (_selected$groupValue$4 = _selected$groupValue$3.item) === null || _selected$groupValue$4 === void 0 ? void 0 : _selected$groupValue$4.id);
      } else if ((_selected$groupValue$5 = selected[groupValue][itemValue]) !== null && _selected$groupValue$5 !== void 0 && (_selected$groupValue$6 = _selected$groupValue$5.item) !== null && _selected$groupValue$6 !== void 0 && _selected$groupValue$6.tagValue) {
        var _selected$groupValue$7, _selected$groupValue$8;

        return tagValue === ((_selected$groupValue$7 = selected[groupValue][itemValue]) === null || _selected$groupValue$7 === void 0 ? void 0 : (_selected$groupValue$8 = _selected$groupValue$7.item) === null || _selected$groupValue$8 === void 0 ? void 0 : _selected$groupValue$8.tagValue);
      }
    }

    return selected[groupValue][itemValue].isSelected;
  }

  return Boolean(selected[groupValue][itemValue]);
};
export var getMenuItems = function getMenuItems(items, onChange, calculateSelected, groupType) {
  var groupValue = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : '';
  var groupLabel = arguments.length > 5 ? arguments[5] : undefined;
  var groupId = arguments.length > 6 ? arguments[6] : undefined;
  var group = arguments.length > 7 ? arguments[7] : undefined;
  var result = (items === null || items === void 0 ? void 0 : items.map(function (item, index) {
    return _objectSpread(_objectSpread({}, item), {}, {
      key: item.id || item.value || index,
      value: String(item.value || item.id || index),
      onClick: function onClick(event) {
        var _item$onClick;

        var params = [event, calculateSelected(groupType || item.type, groupValue, item.value), _objectSpread({
          value: groupValue,
          label: groupLabel || item.label,
          id: groupId || item.id,
          type: groupType || item.type,
          items: items
        }, group || item), item, groupValue, item.value];
        onChange.apply(void 0, params);
        item === null || item === void 0 ? void 0 : (_item$onClick = item.onClick) === null || _item$onClick === void 0 ? void 0 : _item$onClick.call.apply(_item$onClick, [item].concat(params));
      }
    });
  })) || [];
  return result.filter(function (_ref) {
    var noFilter = _ref.noFilter;
    return !noFilter;
  });
};
export var getGroupMenuItems = function getGroupMenuItems(groups, onChange, calculateSelected) {
  var result = groups.map(function (_ref2) {
    var value = _ref2.value,
        label = _ref2.label,
        id = _ref2.id,
        type = _ref2.type,
        items = _ref2.items,
        group = _objectWithoutProperties(_ref2, ["value", "label", "id", "type", "items"]);

    return {
      label: label,
      value: value,
      type: type,
      items: getMenuItems(items, onChange, calculateSelected, type, value, label, id, group)
    };
  });
  return result.filter(function (_ref3) {
    var noFilter = _ref3.noFilter,
        _ref3$items = _ref3.items,
        items = _ref3$items === void 0 ? [] : _ref3$items;
    return !noFilter || items.length > 0;
  });
};
export var calculateSelected = function calculateSelected(selectedTags) {
  return function (type, groupKey, itemKey) {
    var activeGroup = selectedTags[groupKey];

    if (activeGroup) {
      if (type !== groupType.radio && (activeGroup[itemKey] instanceof Object ? activeGroup[itemKey].isSelected : Boolean(activeGroup[itemKey]))) {
        return _objectSpread(_objectSpread({}, selectedTags), {}, _defineProperty({}, groupKey, _objectSpread(_objectSpread({}, activeGroup || {}), {}, _defineProperty({}, itemKey, false))));
      }

      return _objectSpread(_objectSpread({}, selectedTags), {}, _defineProperty({}, groupKey, _objectSpread(_objectSpread({}, type !== groupType.radio ? activeGroup || {} : {}), {}, _defineProperty({}, itemKey, true))));
    }

    return _objectSpread(_objectSpread({}, selectedTags), {}, _defineProperty({}, groupKey, _defineProperty({}, itemKey, true)));
  };
};