import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _assertThisInitialized from "@babel/runtime/helpers/assertThisInitialized";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _defineProperty from "@babel/runtime/helpers/defineProperty";

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

import React, { Component } from 'react';
import { Dropdown } from "@patternfly/react-core/dist/esm/components/Dropdown/Dropdown.js";
import { DropdownToggle } from "@patternfly/react-core/dist/esm/components/Dropdown/DropdownToggle.js";
import { Level } from "@patternfly/react-core/dist/esm/layouts/Level/Level.js";
import { getDefaultOUIAId } from '@patternfly/react-core/';
import PropTypes from 'prop-types';
import FilterInput from './FilterInput.js';
import "../../Filters/./filter-dropdown.css";

var FilterDropdown = /*#__PURE__*/function (_Component) {
  _inherits(FilterDropdown, _Component);

  var _super = _createSuper(FilterDropdown);

  function FilterDropdown() {
    var _this;

    _classCallCheck(this, FilterDropdown);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    _defineProperty(_assertThisInitialized(_this), "state", {
      isOpen: false,
      ouiaStateId: getDefaultOUIAId('RHI/FilterDropdown')
    });

    _defineProperty(_assertThisInitialized(_this), "addRemoveFilters", function (selectedValue, filterName, type, isChecked) {
      switch (type) {
        case 'checkbox':
          isChecked ? _this.props.addFilter(filterName, selectedValue, type) : _this.props.removeFilter(filterName, selectedValue);
          break;

        case 'radio':
          _this.props.addFilter(filterName, selectedValue, type);

          break;
      }
    });

    _defineProperty(_assertThisInitialized(_this), "onToggle", function (isOpen) {
      _this.setState({
        isOpen: isOpen
      });
    });

    return _this;
  }

  _createClass(FilterDropdown, [{
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props = this.props,
          hideCategories = _this$props.hideCategories,
          filters = _this$props.filters,
          filterCategories = _this$props.filterCategories,
          label = _this$props.label,
          ouiaId = _this$props.ouiaId,
          ouiaSafe = _this$props.ouiaSafe;
      var _this$state = this.state,
          isOpen = _this$state.isOpen,
          ouiaStateId = _this$state.ouiaStateId;
      var ouiaFinalId = ouiaId !== undefined ? ouiaId : ouiaStateId;
      return /*#__PURE__*/React.createElement(Dropdown, {
        className: "ins-c-filter__dropdown",
        onSelect: this.onSelect,
        toggle: /*#__PURE__*/React.createElement(DropdownToggle, {
          ouiaId: ouiaFinalId,
          ouiaSafe: ouiaSafe,
          onToggle: this.onToggle
        }, label),
        isOpen: isOpen,
        ouiaId: ouiaFinalId,
        ouiaSafe: ouiaSafe
      }, /*#__PURE__*/React.createElement("div", {
        className: "pf-c-dropdown__menu-item"
      }, filterCategories.map(function (data, index) {
        return !hideCategories.includes(data.urlParam) && /*#__PURE__*/React.createElement(Level, {
          key: "".concat(data.urlParam).concat(index)
        }, data.title, data.values.map(function (item, key) {
          return /*#__PURE__*/React.createElement(FilterInput, {
            key: "check".concat(index).concat(key),
            "aria-label": item.label,
            id: "".concat(data.urlParam).concat(key),
            label: item.label,
            addRemoveFilters: _this2.addRemoveFilters,
            param: data.urlParam,
            type: data.type,
            value: item.value,
            filters: filters
          });
        }), index !== filterCategories.length - 1 && /*#__PURE__*/React.createElement("br", null));
      })));
    }
  }]);

  return FilterDropdown;
}(Component);

FilterDropdown.propTypes = {
  addFilter: PropTypes.func,
  removeFilter: PropTypes.func,
  hideCategories: PropTypes.array,
  filters: PropTypes.object,
  filterCategories: PropTypes.arrayOf(PropTypes.shape({
    title: PropTypes.string,
    type: PropTypes.type,
    urlParam: PropTypes.string,
    values: PropTypes.arrayOf(PropTypes.shape({
      label: PropTypes.node,
      value: PropTypes.any
    }))
  })),
  label: PropTypes.oneOfType([PropTypes.string, PropTypes.node]),
  ouiaId: PropTypes.string,
  ouiaSafe: PropTypes.bool
};
FilterDropdown.defaultProps = {
  addFilter: Function.prototype,
  removeFilter: Function.prototype,
  hideCategories: [],
  filters: {},
  label: 'Filters',
  ouiaSafe: true
};
export default FilterDropdown;