"use strict";
/* Copyright Contributors to the Open Cluster Management project */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AcmCountCard = exports.loadingCard = exports.CardDropdown = void 0;
var react_1 = __importStar(require("react"));
var react_core_1 = require("@patternfly/react-core");
var AcmIcons_1 = require("../AcmIcons/AcmIcons");
var styles_1 = require("@material-ui/styles");
var useStyles = styles_1.makeStyles({
    card: {
        height: function (props) { return (props.cardFooter ? 'auto' : '250px'); },
    },
    cardHeader: {
        '& > div:first-child': {
            padding: '0',
            marginBottom: '8px',
            overflowWrap: 'anywhere',
            lineHeight: '19px',
            display: '-webkit-box',
            '-webkit-line-clamp': '3',
            '-webkit-box-orient': 'vertical',
            overflow: 'hidden',
        },
        '& > svg': {
            width: '32px',
            height: '32px',
        },
    },
    headerDescription: {
        fontSize: 'var(--pf-global--FontSize--sm)',
        lineHeight: '1.4',
        color: 'var(--pf-global--palette--black-700)',
        overflowWrap: 'anywhere',
        display: '-webkit-box',
        '-webkit-line-clamp': '4',
        '-webkit-box-orient': 'vertical',
        overflow: 'hidden',
    },
    tooltip: {},
    actions: {
        width: '1rem',
        padding: '0',
        '&& ul': {
            right: '-1rem',
        },
    },
    count: {
        color: function (props) {
            return props.count !== 0 ? 'var(--pf-global--link--Color)' : 'var(--pf-global--palette--black-900)';
        },
        fontSize: 'var(--pf-global--FontSize--3xl)',
    },
    body: {
        position: function (props) { return (props.cardHeader ? 'absolute' : 'relative'); },
        bottom: '0',
    },
    countTitle: {
        fontSize: 'var(--pf-global--FontSize--sm)',
        fontWeight: 700,
    },
    footer: {
        linkStyle: 'none',
    },
});
function CardDropdown(props) {
    var useStyles = styles_1.makeStyles({
        dropdown: {
            width: '10rem',
        },
    });
    var classes = useStyles();
    var _a = react_1.useState(false), isOpen = _a[0], setOpen = _a[1];
    return (react_1.default.createElement(react_core_1.Dropdown, { className: "dropdownMenu", onClick: function (e) {
            setOpen(!isOpen);
            e.stopPropagation();
        }, toggle: react_1.default.createElement(react_core_1.KebabToggle, { onToggle: function () { return setOpen(!isOpen); } }), isOpen: isOpen, isPlain: true, dropdownItems: props.dropdownItems.map(function (item) { return (react_1.default.createElement(react_core_1.DropdownItem, { className: classes.dropdown, key: item.text, onClick: item.handleAction }, item.text)); }), position: 'right' }));
}
exports.CardDropdown = CardDropdown;
var loadingCard = function (props) {
    var useStyles = styles_1.makeStyles({
        cardSkeleton: {
            height: '250px',
        },
    });
    var classes = useStyles(props);
    return (react_1.default.createElement(react_core_1.Card, { id: props.id, className: classes.cardSkeleton },
        react_1.default.createElement(react_core_1.CardHeader, null,
            react_1.default.createElement(react_core_1.Skeleton, { width: "25%" })),
        react_1.default.createElement(react_core_1.CardBody, null,
            react_1.default.createElement(react_core_1.Skeleton, { width: "100%" }),
            react_1.default.createElement("br", null),
            react_1.default.createElement(react_core_1.Skeleton, { width: "100%" })),
        react_1.default.createElement(react_core_1.CardFooter, null,
            react_1.default.createElement(react_core_1.Skeleton, { width: "25%", height: "4rem" }))));
};
exports.loadingCard = loadingCard;
var AcmCountCard = function (props) {
    var classes = useStyles(props);
    var id = props.id, loading = props.loading, countTitle = props.countTitle, cardFooter = props.cardFooter, cardHeader = props.cardHeader;
    var count = "" + props.count;
    if (parseInt(count) >= 1000) {
        count = (parseInt(count) - (parseInt(count) % 100)) / 1000 + "k";
    }
    if (loading)
        return exports.loadingCard(props);
    return (react_1.default.createElement(react_core_1.Card, { id: id, className: classes.card, onClick: props.onCardClick, isSelectable: !!props.onCardClick, isFlat: !props.onCardClick, onKeyPress: props.onKeyPress },
        cardHeader && (react_1.default.createElement(react_core_1.CardHeader, null,
            cardHeader.actions && cardHeader.actions.length > 0 && (react_1.default.createElement(react_core_1.CardActions, { className: classes.actions },
                react_1.default.createElement(CardDropdown, { dropdownItems: cardHeader.actions }))),
            react_1.default.createElement(react_core_1.CardHeaderMain, { className: classes.cardHeader },
                cardHeader.hasIcon && react_1.default.createElement(AcmIcons_1.AcmIcon, { icon: AcmIcons_1.AcmIconVariant.template }),
                react_1.default.createElement(react_core_1.CardTitle, null, cardHeader.title),
                react_1.default.createElement("p", { className: classes.headerDescription }, cardHeader.description)))),
        react_1.default.createElement(react_core_1.CardBody, { className: classes.body },
            react_1.default.createElement("div", { className: classes.count }, count),
            react_1.default.createElement("div", { className: classes.countTitle }, countTitle)),
        cardFooter && (react_1.default.createElement(react_core_1.CardFooter, { className: classes.footer },
            cardFooter.countDescription || null,
            cardFooter.countLink || null))));
};
exports.AcmCountCard = AcmCountCard;
//# sourceMappingURL=AcmCountCard.js.map