"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

require("./tagCount.css");

var _classnames = _interopRequireDefault(require("classnames"));

var _Button = require("@patternfly/react-core/dist/js/components/Button/Button.js");

var _tagIcon = _interopRequireDefault(require("@patternfly/react-icons/dist/js/icons/tag-icon"));

var TagCount = function TagCount(_ref) {
  var count = _ref.count,
      onTagClick = _ref.onTagClick,
      className = _ref.className,
      props = (0, _objectWithoutProperties2["default"])(_ref, ["count", "onTagClick", "className"]);
  return /*#__PURE__*/_react["default"].createElement(_Button.Button, (0, _extends2["default"])({}, props, {
    variant: "plain",
    isDisabled: !count,
    className: (0, _classnames["default"])('ins-c-tag-count', className),
    onClick: onTagClick
  }), /*#__PURE__*/_react["default"].createElement(_tagIcon["default"], {
    size: "md"
  }), /*#__PURE__*/_react["default"].createElement("span", {
    className: "ins-c-tag__text"
  }, count));
};

TagCount.propTypes = {
  count: _propTypes["default"].number,
  onTagClick: _propTypes["default"].func,
  className: _propTypes["default"].string
};
TagCount.defaultProps = {
  onTagClick: function onTagClick() {
    return undefined;
  }
};
var _default = TagCount;
exports["default"] = _default;