"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _orderBy2 = _interopRequireDefault(require("lodash/orderBy"));

var _isPlainObject2 = _interopRequireDefault(require("lodash/isPlainObject"));

var _uniqueId2 = _interopRequireDefault(require("lodash/uniqueId"));

var _defaults2 = _interopRequireDefault(require("lodash/defaults"));

var _assign2 = _interopRequireDefault(require("lodash/assign"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _victoryCore = require("victory-core");

var _flyout = _interopRequireDefault(require("./flyout"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance"); }

function _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (typeof call === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var fallbackProps = {
  cornerRadius: 5,
  pointerLength: 10,
  pointerWidth: 10
};

var VictoryTooltip =
/*#__PURE__*/
function (_React$Component) {
  _inherits(VictoryTooltip, _React$Component);

  function VictoryTooltip(props) {
    var _this;

    _classCallCheck(this, VictoryTooltip);

    _this = _possibleConstructorReturn(this, (VictoryTooltip.__proto__ || Object.getPrototypeOf(VictoryTooltip)).call(this, props));
    _this.id = props.id === undefined ? (0, _uniqueId2.default)("tooltip-") : props.id;
    return _this;
  }

  _createClass(VictoryTooltip, [{
    key: "getDefaultOrientation",
    value: function getDefaultOrientation(props) {
      var datum = props.datum,
          horizontal = props.horizontal,
          polar = props.polar;

      if (!polar) {
        var positive = horizontal ? "right" : "top";
        var negative = horizontal ? "left" : "bottom";
        return datum && datum.y < 0 ? negative : positive;
      } else {
        return this.getPolarOrientation(props, datum);
      }
    }
  }, {
    key: "getPolarOrientation",
    value: function getPolarOrientation(props, datum) {
      var degrees = _victoryCore.LabelHelpers.getDegrees(props, datum);

      var placement = props.labelPlacement || "vertical";

      if (placement === " vertical") {
        return this.getVerticalOrientations(degrees);
      } else if (placement === "parallel") {
        return degrees < 90 || degrees > 270 ? "right" : "left";
      } else {
        return degrees > 180 ? "bottom" : "top";
      }
    }
  }, {
    key: "getVerticalOrientations",
    value: function getVerticalOrientations(degrees) {
      // eslint-disable-next-line no-magic-numbers
      if (degrees < 45 || degrees > 315) {
        return "right"; // eslint-disable-next-line no-magic-numbers
      } else if (degrees >= 45 && degrees <= 135) {
        return "top"; // eslint-disable-next-line no-magic-numbers
      } else if (degrees > 135 && degrees < 225) {
        return "left";
      } else {
        return "bottom";
      }
    }
  }, {
    key: "getStyles",
    value: function getStyles(props) {
      var theme = props.theme || _victoryCore.VictoryTheme.grayscale;
      var defaultLabelStyles = theme && theme.tooltip && theme.tooltip.style ? theme.tooltip.style : {};
      var baseLabelStyle = Array.isArray(props.style) ? props.style.map(function (s) {
        return (0, _defaults2.default)({}, s, defaultLabelStyles);
      }) : (0, _defaults2.default)({}, props.style, defaultLabelStyles);
      var defaultFlyoutStyles = theme && theme.tooltip && theme.tooltip.flyoutStyle ? theme.tooltip.flyoutStyle : {};
      var baseFlyoutStyle = props.flyoutStyle ? (0, _defaults2.default)({}, props.flyoutStyle, defaultFlyoutStyles) : defaultFlyoutStyles;
      var style = Array.isArray(baseLabelStyle) ? baseLabelStyle.map(function (s) {
        return _victoryCore.Helpers.evaluateStyle(s, props);
      }) : _victoryCore.Helpers.evaluateStyle(baseLabelStyle, props);

      var flyoutStyle = _victoryCore.Helpers.evaluateStyle(baseFlyoutStyle, (0, _assign2.default)({}, props, {
        style: style
      }));

      return {
        style: style,
        flyoutStyle: flyoutStyle
      };
    }
  }, {
    key: "getEvaluatedProps",
    value: function getEvaluatedProps(props) {
      var cornerRadius = props.cornerRadius,
          centerOffset = props.centerOffset,
          dx = props.dx,
          dy = props.dy;

      var active = _victoryCore.Helpers.evaluateProp(props.active, props);

      var text = _victoryCore.Helpers.evaluateProp(props.text, (0, _assign2.default)({}, props, {
        active: active
      }));

      var _getStyles = this.getStyles((0, _assign2.default)({}, props, {
        active: active,
        text: text
      })),
          style = _getStyles.style,
          flyoutStyle = _getStyles.flyoutStyle;

      var orientation = _victoryCore.Helpers.evaluateProp(props.orientation, (0, _assign2.default)({}, props, {
        active: active,
        text: text,
        style: style,
        flyoutStyle: flyoutStyle
      })) || this.getDefaultOrientation(props);
      var padding = _victoryCore.Helpers.evaluateProp(props.flyoutPadding, (0, _assign2.default)({}, props, {
        active: active,
        text: text,
        style: style,
        flyoutStyle: flyoutStyle,
        orientation: orientation
      })) || this.getLabelPadding(style);

      var flyoutPadding = _victoryCore.Helpers.getPadding({
        padding: padding
      });

      var pointerWidth = _victoryCore.Helpers.evaluateProp(props.pointerWidth, (0, _assign2.default)({}, props, {
        active: active,
        text: text,
        style: style,
        flyoutStyle: flyoutStyle,
        orientation: orientation
      }));

      var pointerLength = _victoryCore.Helpers.evaluateProp(props.pointerLength, (0, _assign2.default)({}, props, {
        active: active,
        text: text,
        style: style,
        flyoutStyle: flyoutStyle,
        orientation: orientation
      }));

      var labelSize = _victoryCore.TextSize.approximateTextSize(text, style);

      var _getDimensions = this.getDimensions((0, _assign2.default)({}, props, {
        style: style,
        flyoutStyle: flyoutStyle,
        active: active,
        text: text,
        orientation: orientation,
        flyoutPadding: flyoutPadding,
        pointerWidth: pointerWidth,
        pointerLength: pointerLength
      }), labelSize),
          flyoutHeight = _getDimensions.flyoutHeight,
          flyoutWidth = _getDimensions.flyoutWidth;

      var evaluatedProps = (0, _assign2.default)({}, props, {
        active: active,
        text: text,
        style: style,
        flyoutStyle: flyoutStyle,
        orientation: orientation,
        flyoutHeight: flyoutHeight,
        flyoutWidth: flyoutWidth,
        flyoutPadding: flyoutPadding,
        pointerWidth: pointerWidth,
        pointerLength: pointerLength
      });
      var offsetX = (0, _isPlainObject2.default)(centerOffset) && centerOffset.x !== undefined ? _victoryCore.Helpers.evaluateProp(centerOffset.x, evaluatedProps) : 0;
      var offsetY = (0, _isPlainObject2.default)(centerOffset) && centerOffset.y !== undefined ? _victoryCore.Helpers.evaluateProp(centerOffset.y, evaluatedProps) : 0;
      return (0, _assign2.default)({}, evaluatedProps, {
        centerOffset: {
          x: offsetX,
          y: offsetY
        },
        dx: dx !== undefined ? _victoryCore.Helpers.evaluateProp(dx, evaluatedProps) : 0,
        dy: dy !== undefined ? _victoryCore.Helpers.evaluateProp(dy, evaluatedProps) : 0,
        cornerRadius: _victoryCore.Helpers.evaluateProp(cornerRadius, evaluatedProps)
      });
    }
  }, {
    key: "getCalculatedValues",
    value: function getCalculatedValues(props) {
      var style = props.style,
          text = props.text,
          flyoutStyle = props.flyoutStyle,
          flyoutHeight = props.flyoutHeight,
          flyoutWidth = props.flyoutWidth;

      var labelSize = _victoryCore.TextSize.approximateTextSize(text, style);

      var flyoutDimensions = {
        height: flyoutHeight,
        width: flyoutWidth
      };
      var flyoutCenter = this.getFlyoutCenter(props, flyoutDimensions);
      var transform = this.getTransform(props);
      return {
        style: style,
        flyoutStyle: flyoutStyle,
        labelSize: labelSize,
        flyoutDimensions: flyoutDimensions,
        flyoutCenter: flyoutCenter,
        transform: transform
      };
    }
  }, {
    key: "getTransform",
    value: function getTransform(props) {
      var x = props.x,
          y = props.y,
          style = props.style;
      var labelStyle = style || {};
      var angle = labelStyle.angle || props.angle || this.getDefaultAngle(props);
      return angle ? "rotate(".concat(angle, " ").concat(x, " ").concat(y, ")") : undefined;
    } // eslint-disable-next-line complexity

  }, {
    key: "getDefaultAngle",
    value: function getDefaultAngle(props) {
      var polar = props.polar,
          labelPlacement = props.labelPlacement,
          orientation = props.orientation,
          datum = props.datum;

      if (!polar || !labelPlacement || labelPlacement === "vertical") {
        return 0;
      }

      var degrees = _victoryCore.LabelHelpers.getDegrees(props, datum);

      var sign = degrees > 90 && degrees < 180 || degrees > 270 ? 1 : -1;
      var labelRotation = labelPlacement === "perpendicular" ? 0 : 90;
      var angle;

      if (degrees === 0 || degrees === 180) {
        angle = orientation === "top" && degrees === 180 ? 270 : 90;
      } else if (degrees > 0 && degrees < 180) {
        angle = 90 - degrees;
      } else if (degrees > 180 && degrees < 360) {
        angle = 270 - degrees;
      }

      return angle + sign * labelRotation;
    }
  }, {
    key: "constrainTooltip",
    value: function constrainTooltip(center, props, dimensions) {
      var x = center.x,
          y = center.y;
      var width = dimensions.width,
          height = dimensions.height;
      var extent = {
        x: [0, props.width],
        y: [0, props.height]
      };
      var flyoutExtent = {
        x: [x - width / 2, x + width / 2],
        y: [y - height / 2, y + height / 2]
      };
      var adjustments = {
        x: [flyoutExtent.x[0] < extent.x[0] ? extent.x[0] - flyoutExtent.x[0] : 0, flyoutExtent.x[1] > extent.x[1] ? flyoutExtent.x[1] - extent.x[1] : 0],
        y: [flyoutExtent.y[0] < extent.y[0] ? extent.y[0] - flyoutExtent.y[0] : 0, flyoutExtent.y[1] > extent.y[1] ? flyoutExtent.y[1] - extent.y[1] : 0]
      };
      return {
        x: Math.round(x + adjustments.x[0] - adjustments.x[1]),
        y: Math.round(y + adjustments.y[0] - adjustments.y[1])
      };
    } // eslint-disable-next-line complexity

  }, {
    key: "getFlyoutCenter",
    value: function getFlyoutCenter(props, dimensions) {
      var x = props.x,
          y = props.y,
          dx = props.dx,
          dy = props.dy,
          pointerLength = props.pointerLength,
          orientation = props.orientation,
          constrainToVisibleArea = props.constrainToVisibleArea,
          centerOffset = props.centerOffset;
      var height = dimensions.height,
          width = dimensions.width;
      var xSign = orientation === "left" ? -1 : 1;
      var ySign = orientation === "bottom" ? -1 : 1;
      var flyoutCenter = {
        x: orientation === "left" || orientation === "right" ? x + xSign * (pointerLength + width / 2 + xSign * dx) : x + dx,
        y: orientation === "top" || orientation === "bottom" ? y - ySign * (pointerLength + height / 2 - ySign * dy) : y + dy
      };
      var center = {
        x: (0, _isPlainObject2.default)(props.center) && props.center.x !== undefined ? props.center.x : flyoutCenter.x,
        y: (0, _isPlainObject2.default)(props.center) && props.center.y !== undefined ? props.center.y : flyoutCenter.y
      };
      var centerWithOffset = {
        x: center.x + centerOffset.x,
        y: center.y + centerOffset.y
      };
      return constrainToVisibleArea ? this.constrainTooltip(centerWithOffset, props, dimensions) : centerWithOffset;
    }
  }, {
    key: "getLabelPadding",
    value: function getLabelPadding(style) {
      if (!style) {
        return 0;
      }

      var paddings = Array.isArray(style) ? style.map(function (s) {
        return s.padding;
      }) : [style.padding];
      return Math.max.apply(Math, _toConsumableArray(paddings).concat([0]));
    }
  }, {
    key: "getDimensions",
    value: function getDimensions(props, labelSize) {
      var orientation = props.orientation,
          pointerLength = props.pointerLength,
          pointerWidth = props.pointerWidth,
          flyoutHeight = props.flyoutHeight,
          flyoutWidth = props.flyoutWidth,
          flyoutPadding = props.flyoutPadding;

      var cornerRadius = _victoryCore.Helpers.evaluateProp(props.cornerRadius, props);

      var getHeight = function () {
        var calculatedHeight = labelSize.height + flyoutPadding.top + flyoutPadding.bottom;
        var minHeight = orientation === "top" || orientation === "bottom" ? 2 * cornerRadius : 2 * cornerRadius + pointerWidth;
        return Math.max(minHeight, calculatedHeight);
      };

      var getWidth = function () {
        var calculatedWidth = labelSize.width + flyoutPadding.left + flyoutPadding.right;
        var minWidth = orientation === "left" || orientation === "right" ? 2 * cornerRadius + pointerLength : 2 * cornerRadius;
        return Math.max(minWidth, calculatedWidth);
      };

      return {
        flyoutHeight: flyoutHeight ? _victoryCore.Helpers.evaluateProp(flyoutHeight, props) : getHeight(props, labelSize, orientation),
        flyoutWidth: flyoutWidth ? _victoryCore.Helpers.evaluateProp(flyoutWidth, props) : getWidth(props, labelSize, orientation)
      };
    }
  }, {
    key: "getLabelProps",
    value: function getLabelProps(props, calculatedValues) {
      var flyoutCenter = calculatedValues.flyoutCenter,
          style = calculatedValues.style,
          labelSize = calculatedValues.labelSize,
          _calculatedValues$dy = calculatedValues.dy,
          dy = _calculatedValues$dy === void 0 ? 0 : _calculatedValues$dy,
          _calculatedValues$dx = calculatedValues.dx,
          dx = _calculatedValues$dx === void 0 ? 0 : _calculatedValues$dx;
      var text = props.text,
          datum = props.datum,
          activePoints = props.activePoints,
          labelComponent = props.labelComponent,
          index = props.index,
          flyoutPadding = props.flyoutPadding;
      var textAnchor = (Array.isArray(style) && style.length ? style[0].textAnchor : style.textAnchor) || "middle";

      var getLabelX = function () {
        if (!textAnchor || textAnchor === "middle") {
          return flyoutCenter.x;
        }

        var sign = textAnchor === "end" ? -1 : 1;
        return flyoutCenter.x - sign * (labelSize.width / 2);
      };

      return (0, _defaults2.default)({}, labelComponent.props, {
        key: "".concat(this.id, "-label-").concat(index),
        text: text,
        datum: datum,
        activePoints: activePoints,
        textAnchor: textAnchor,
        dy: dy,
        dx: dx,
        style: style,
        x: getLabelX() + (flyoutPadding.left - flyoutPadding.right) / 2,
        y: flyoutCenter.y + (flyoutPadding.top - flyoutPadding.bottom) / 2,
        verticalAnchor: "middle",
        angle: style.angle
      });
    }
  }, {
    key: "getPointerOrientation",
    value: function getPointerOrientation(point, center, flyoutDimensions) {
      var edges = {
        bottom: center.y + flyoutDimensions.height / 2,
        top: center.y - flyoutDimensions.height / 2,
        left: center.x - flyoutDimensions.width / 2,
        right: center.x + flyoutDimensions.width / 2
      };
      var gaps = [{
        side: "top",
        val: edges.top > point.y ? edges.top - point.y : -1
      }, {
        side: "bottom",
        val: edges.bottom < point.y ? point.y - edges.bottom : -1
      }, {
        side: "right",
        val: edges.right < point.x ? point.x - edges.right : -1
      }, {
        side: "left",
        val: edges.left > point.x ? edges.left - point.x : -1
      }];
      return (0, _orderBy2.default)(gaps, "val", "desc")[0].side;
    }
  }, {
    key: "getFlyoutProps",
    value: function getFlyoutProps(props, calculatedValues) {
      var flyoutDimensions = calculatedValues.flyoutDimensions,
          flyoutStyle = calculatedValues.flyoutStyle,
          flyoutCenter = calculatedValues.flyoutCenter;
      var x = props.x,
          y = props.y,
          dx = props.dx,
          dy = props.dy,
          datum = props.datum,
          activePoints = props.activePoints,
          index = props.index,
          pointerLength = props.pointerLength,
          pointerWidth = props.pointerWidth,
          cornerRadius = props.cornerRadius,
          events = props.events,
          flyoutComponent = props.flyoutComponent;

      var pointerOrientation = _victoryCore.Helpers.evaluateProp(props.pointerOrientation, props);

      return (0, _defaults2.default)({}, flyoutComponent.props, {
        x: x,
        y: y,
        dx: dx,
        dy: dy,
        datum: datum,
        activePoints: activePoints,
        index: index,
        pointerLength: pointerLength,
        pointerWidth: pointerWidth,
        cornerRadius: cornerRadius,
        events: events,
        orientation: pointerOrientation || this.getPointerOrientation({
          x: x,
          y: y
        }, flyoutCenter, flyoutDimensions),
        key: "".concat(this.id, "-tooltip-").concat(index),
        width: flyoutDimensions.width,
        height: flyoutDimensions.height,
        style: flyoutStyle,
        center: flyoutCenter
      });
    } // Overridden in victory-core-native

  }, {
    key: "renderTooltip",
    value: function renderTooltip(props) {
      var active = _victoryCore.Helpers.evaluateProp(props.active, props);

      var renderInPortal = props.renderInPortal;

      if (!active) {
        return renderInPortal ? _react.default.createElement(_victoryCore.VictoryPortal, null, null) : null;
      }

      var evaluatedProps = this.getEvaluatedProps(props);
      var flyoutComponent = evaluatedProps.flyoutComponent,
          labelComponent = evaluatedProps.labelComponent,
          groupComponent = evaluatedProps.groupComponent;
      var calculatedValues = this.getCalculatedValues(evaluatedProps);
      var children = [_react.default.cloneElement(flyoutComponent, this.getFlyoutProps(evaluatedProps, calculatedValues)), _react.default.cloneElement(labelComponent, this.getLabelProps(evaluatedProps, calculatedValues))];

      var tooltip = _react.default.cloneElement(groupComponent, {
        role: "presentation",
        transform: calculatedValues.transform
      }, children);

      return renderInPortal ? _react.default.createElement(_victoryCore.VictoryPortal, null, tooltip) : tooltip;
    }
  }, {
    key: "render",
    value: function render() {
      var props = _victoryCore.Helpers.modifyProps(this.props, fallbackProps, "tooltip");

      return this.renderTooltip(props);
    }
  }]);

  return VictoryTooltip;
}(_react.default.Component);

exports.default = VictoryTooltip;
Object.defineProperty(VictoryTooltip, "displayName", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: "VictoryTooltip"
});
Object.defineProperty(VictoryTooltip, "role", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: "tooltip"
});
Object.defineProperty(VictoryTooltip, "propTypes", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: {
    activateData: _propTypes.default.bool,
    active: _propTypes.default.oneOfType([_propTypes.default.bool, _propTypes.default.func]),
    activePoints: _propTypes.default.array,
    angle: _propTypes.default.number,
    center: _propTypes.default.shape({
      x: _victoryCore.PropTypes.nonNegative,
      y: _victoryCore.PropTypes.nonNegative
    }),
    centerOffset: _propTypes.default.shape({
      x: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.func]),
      y: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.func])
    }),
    constrainToVisibleArea: _propTypes.default.bool,
    cornerRadius: _propTypes.default.oneOfType([_victoryCore.PropTypes.nonNegative, _propTypes.default.func]),
    data: _propTypes.default.array,
    datum: _propTypes.default.object,
    dx: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.func]),
    dy: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.func]),
    events: _propTypes.default.object,
    flyoutComponent: _propTypes.default.element,
    flyoutHeight: _propTypes.default.oneOfType([_victoryCore.PropTypes.nonNegative, _propTypes.default.func]),
    flyoutPadding: _propTypes.default.oneOfType([_propTypes.default.func, _propTypes.default.number, _propTypes.default.shape({
      top: _propTypes.default.number,
      bottom: _propTypes.default.number,
      left: _propTypes.default.number,
      right: _propTypes.default.number
    })]),
    flyoutStyle: _propTypes.default.object,
    flyoutWidth: _propTypes.default.oneOfType([_victoryCore.PropTypes.nonNegative, _propTypes.default.func]),
    groupComponent: _propTypes.default.element,
    height: _propTypes.default.number,
    horizontal: _propTypes.default.bool,
    id: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),
    index: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),
    labelComponent: _propTypes.default.element,
    orientation: _propTypes.default.oneOfType([_propTypes.default.oneOf(["top", "bottom", "left", "right"]), _propTypes.default.func]),
    pointerLength: _propTypes.default.oneOfType([_victoryCore.PropTypes.nonNegative, _propTypes.default.func]),
    pointerOrientation: _propTypes.default.oneOfType([_propTypes.default.oneOf(["top", "bottom", "left", "right"]), _propTypes.default.func]),
    pointerWidth: _propTypes.default.oneOfType([_victoryCore.PropTypes.nonNegative, _propTypes.default.func]),
    polar: _propTypes.default.bool,
    renderInPortal: _propTypes.default.bool,
    scale: _propTypes.default.shape({
      x: _victoryCore.PropTypes.scale,
      y: _victoryCore.PropTypes.scale
    }),
    style: _propTypes.default.oneOfType([_propTypes.default.object, _propTypes.default.array]),
    text: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number, _propTypes.default.func, _propTypes.default.array]),
    theme: _propTypes.default.object,
    width: _propTypes.default.number,
    x: _propTypes.default.number,
    y: _propTypes.default.number
  }
});
Object.defineProperty(VictoryTooltip, "defaultProps", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: {
    active: false,
    renderInPortal: true,
    labelComponent: _react.default.createElement(_victoryCore.VictoryLabel, null),
    flyoutComponent: _react.default.createElement(_flyout.default, null),
    groupComponent: _react.default.createElement("g", null)
  }
});
Object.defineProperty(VictoryTooltip, "defaultEvents", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: function (props) {
    var activate = props.activateData ? [{
      target: "labels",
      mutation: function () {
        return {
          active: true
        };
      }
    }, {
      target: "data",
      mutation: function () {
        return {
          active: true
        };
      }
    }] : [{
      target: "labels",
      mutation: function () {
        return {
          active: true
        };
      }
    }];
    var deactivate = props.activateData ? [{
      target: "labels",
      mutation: function () {
        return {
          active: undefined
        };
      }
    }, {
      target: "data",
      mutation: function () {
        return {
          active: undefined
        };
      }
    }] : [{
      target: "labels",
      mutation: function () {
        return {
          active: undefined
        };
      }
    }];
    return [{
      target: "data",
      eventHandlers: {
        onMouseOver: function () {
          return activate;
        },
        onFocus: function () {
          return activate;
        },
        onTouchStart: function () {
          return activate;
        },
        onMouseOut: function () {
          return deactivate;
        },
        onBlur: function () {
          return deactivate;
        },
        onTouchEnd: function () {
          return deactivate;
        }
      }
    }];
  }
});