"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChartLegend = exports.ChartLegendRowGutter = exports.ChartLegendPosition = exports.ChartLegendOrientation = void 0;
const tslib_1 = require("tslib");
const React = tslib_1.__importStar(require("react"));
const hoist_non_react_statics_1 = tslib_1.__importDefault(require("hoist-non-react-statics"));
const victory_legend_1 = require("victory-legend");
const ChartContainer_1 = require("../ChartContainer");
const ChartLabel_1 = require("../ChartLabel");
const ChartPoint_1 = require("../ChartPoint");
const ChartUtils_1 = require("../ChartUtils");
var ChartLegendOrientation;
(function (ChartLegendOrientation) {
    ChartLegendOrientation["horizontal"] = "horizontal";
    ChartLegendOrientation["vertical"] = "vertical";
})(ChartLegendOrientation = exports.ChartLegendOrientation || (exports.ChartLegendOrientation = {}));
var ChartLegendPosition;
(function (ChartLegendPosition) {
    ChartLegendPosition["bottom"] = "bottom";
    ChartLegendPosition["bottomLeft"] = "bottom-left";
    ChartLegendPosition["right"] = "right";
})(ChartLegendPosition = exports.ChartLegendPosition || (exports.ChartLegendPosition = {}));
var ChartLegendRowGutter;
(function (ChartLegendRowGutter) {
    ChartLegendRowGutter["bottom"] = "bottom";
    ChartLegendRowGutter["top"] = "top";
})(ChartLegendRowGutter = exports.ChartLegendRowGutter || (exports.ChartLegendRowGutter = {}));
const ChartLegend = (_a) => {
    var { containerComponent = React.createElement(ChartContainer_1.ChartContainer, null), dataComponent = React.createElement(ChartPoint_1.ChartPoint, null), labelComponent = React.createElement(ChartLabel_1.ChartLabel, null), responsive = true, themeColor, themeVariant, titleComponent = React.createElement(ChartLabel_1.ChartLabel, null), 
    // destructure last
    theme = ChartUtils_1.getTheme(themeColor, themeVariant) } = _a, rest = tslib_1.__rest(_a, ["containerComponent", "dataComponent", "labelComponent", "responsive", "themeColor", "themeVariant", "titleComponent", "theme"]);
    // Clone so users can override container props
    const container = React.cloneElement(containerComponent, Object.assign({ responsive,
        theme }, containerComponent.props));
    // Note: containerComponent is required for theme
    return (React.createElement(victory_legend_1.VictoryLegend, Object.assign({ containerComponent: container, dataComponent: dataComponent, labelComponent: labelComponent, theme: theme, titleComponent: titleComponent }, rest)));
};
exports.ChartLegend = ChartLegend;
exports.ChartLegend.displayName = 'ChartLegend';
// Note: VictoryLegend.role must be hoisted, but getBaseProps causes error with ChartVoronoiContainer
hoist_non_react_statics_1.default(exports.ChartLegend, victory_legend_1.VictoryLegend, { getBaseProps: true });
exports.ChartLegend.getBaseProps = (props) => {
    const theme = ChartUtils_1.getTheme(null, null);
    return victory_legend_1.VictoryLegend.getBaseProps(Object.assign({ titleComponent: React.createElement(ChartLabel_1.ChartLabel, null) }, props), {
        height: theme.chart.height,
        orientation: theme.legend.orientation,
        titleOrientation: theme.legend.titleOrientation,
        x: 0,
        y: 0,
        width: theme.chart.width
    });
};
//# sourceMappingURL=ChartLegend.js.map