"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importDefault(require("react"));
var react_table_1 = require("@patternfly/react-table");
var classnames_1 = __importDefault(require("classnames"));
var TreeRowWrapper = function (props) {
    var className = props.className;
    var _a = props.row || {}, level = _a.level, isTreeOpen = _a.isTreeOpen, point = _a.point, posinset = _a.posinset;
    return (react_1.default.createElement(react_table_1.RowWrapper, __assign({}, props, { "aria-level": level === undefined ? 1 : level + 1, "aria-posinset": posinset, "aria-setsize": point ? point.size : 0, className: (0, classnames_1.default)({
            className: className,
            'pf-m-expandable': isTreeOpen === true || isTreeOpen === false,
            'pf-m-expanded': isTreeOpen === true,
        }) })));
};
exports.default = TreeRowWrapper;
//# sourceMappingURL=rowWrapper.js.map