import React from 'react';
import { Tooltip } from "@patternfly/react-core/dist/esm/components/Tooltip/Tooltip.js";

function parseCvssScore(cvssV2, cvssV3) {
  var withLabels = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
  var v2Tooltip = 'Prior to 2016 (approximately), CVEs were scored with Common Vulnerability Scoring System v2.';
  var naTooltip = 'CVEs published before 2005 (approximately) did not have a CVSS Base Score.';
  return cvssV3 && parseFloat(cvssV3).toFixed(1) || cvssV2 && /*#__PURE__*/React.createElement(Tooltip, {
    content: v2Tooltip,
    position: 'left'
  }, /*#__PURE__*/React.createElement("span", null, "".concat(parseFloat(cvssV2).toFixed(1)), " ", withLabels && '(CVSSv2)')) || /*#__PURE__*/React.createElement(Tooltip, {
    content: naTooltip,
    position: 'left'
  }, /*#__PURE__*/React.createElement("span", null, "N/A"));
}

export default parseCvssScore;