/// <reference types="react" />
import { ObjectMetadata } from 'console-sdk-ai-lib';
import { AgentClusterInstallK8sResource, ClusterDeploymentK8sResource } from '../../types';
import { AgentSelectorChangeProps, ClusterDeploymentHostsSelectionValues } from '../ClusterDeployment/types';
export declare type ClusterDeploymentParams = {
    name: string;
    namespace: string;
    baseDnsDomain: string;
    annotations?: {
        [key: string]: string;
    };
    pullSecretName: string;
};
export declare const getAgentSelectorFieldsFromAnnotations: (annotations?: ObjectMetadata['annotations']) => AgentSelectorChangeProps;
export declare const getAnnotationsFromAgentSelector: (clusterDeployment: ClusterDeploymentK8sResource, values: ClusterDeploymentHostsSelectionValues) => ObjectMetadata['annotations'];
export declare const getClusterDeploymentResource: ({ name, namespace, baseDnsDomain, annotations, pullSecretName, }: ClusterDeploymentParams) => ClusterDeploymentK8sResource;
export declare const getConsoleUrl: (clusterDeployment?: ClusterDeploymentK8sResource | undefined) => string;
export declare const getClusterApiUrl: (clusterDeployment?: ClusterDeploymentK8sResource | undefined) => string;
declare type ClusterPropertyKeys = 'name' | 'openshiftVersion' | 'baseDnsDomain' | 'apiVip' | 'ingressVip' | 'clusterId' | 'clusterNetworkCidr' | 'clusterNetworkHostPrefix' | 'serviceNetworkCidr' | 'installedTimestamp';
declare type ClusterPropertyItem = {
    key: string;
    value?: React.ReactNode;
};
export declare const getClusterProperties: (clusterDeployment: ClusterDeploymentK8sResource, agentClusterInstall: AgentClusterInstallK8sResource) => {
    name: ClusterPropertyItem;
    openshiftVersion: ClusterPropertyItem;
    baseDnsDomain: ClusterPropertyItem;
    clusterNetworkCidr: ClusterPropertyItem;
    clusterNetworkHostPrefix: ClusterPropertyItem;
    serviceNetworkCidr: ClusterPropertyItem;
    apiVip: ClusterPropertyItem;
    ingressVip: ClusterPropertyItem;
    clusterId: ClusterPropertyItem;
    installedTimestamp: ClusterPropertyItem;
};
export {};
