import _extends from "@babel/runtime/helpers/extends";
import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

import { Toolbar } from "@patternfly/react-core/dist/esm/components/Toolbar/Toolbar.js";
import { ToolbarContent } from "@patternfly/react-core/dist/esm/components/Toolbar/ToolbarContent.js";
import { ToolbarGroup } from "@patternfly/react-core/dist/esm/components/Toolbar/ToolbarGroup.js";
import { ToolbarItem } from "@patternfly/react-core/dist/esm/components/Toolbar/ToolbarItem.js";
import { Pagination } from "@patternfly/react-core/dist/esm/components/Pagination/Pagination.js";
import { Button } from "@patternfly/react-core/dist/esm/components/Button/Button.js";
import { ToolbarExpandIconWrapper } from "@patternfly/react-core/dist/esm/components/Toolbar/ToolbarExpandIconWrapper.js";
import AngleDownIcon from "@patternfly/react-icons/dist/esm/icons/angle-down-icon";
import AngleRightIcon from "@patternfly/react-icons/dist/esm/icons/angle-right-icon";
import React, { Component } from 'react';
import Actions from './Actions';
import { BulkSelect } from '../BulkSelect';
import { ConditionalFilter } from '../ConditionalFilter';
import { DownloadButton } from '../DownloadButton';
import { FilterChips } from '../FilterChips';
import PropTypes from 'prop-types';
import SortBy from './SortBy';
import { SortByDirection } from '@patternfly/react-table';
import "../../PrimaryToolbar/./primary-toolbar.css";

var PrimaryToolbar = /*#__PURE__*/function (_Component) {
  _inherits(PrimaryToolbar, _Component);

  var _super = _createSuper(PrimaryToolbar);

  function PrimaryToolbar() {
    _classCallCheck(this, PrimaryToolbar);

    return _super.apply(this, arguments);
  }

  _createClass(PrimaryToolbar, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          id = _this$props.id,
          className = _this$props.className,
          toggleIsExpanded = _this$props.toggleIsExpanded,
          bulkSelect = _this$props.bulkSelect,
          filterConfig = _this$props.filterConfig,
          dedicatedAction = _this$props.dedicatedAction,
          actionsConfig = _this$props.actionsConfig,
          sortByConfig = _this$props.sortByConfig,
          pagination = _this$props.pagination,
          activeFiltersConfig = _this$props.activeFiltersConfig,
          children = _this$props.children,
          exportConfig = _this$props.exportConfig,
          expandAll = _this$props.expandAll,
          useMobileLayout = _this$props.useMobileLayout,
          props = _objectWithoutProperties(_this$props, ["id", "className", "toggleIsExpanded", "bulkSelect", "filterConfig", "dedicatedAction", "actionsConfig", "sortByConfig", "pagination", "activeFiltersConfig", "children", "exportConfig", "expandAll", "useMobileLayout"]);

      var overflowActions = _toConsumableArray(sortByConfig ? [{
        label: 'Sort order ASC',
        props: {
          isDisabled: sortByConfig.direction === SortByDirection.asc
        },
        onClick: function onClick(e) {
          return sortByConfig.onSortChange && sortByConfig.onSortChange(e, SortByDirection.asc);
        }
      }, {
        label: 'Sort order DESC',
        props: {
          isDisabled: sortByConfig.direction === SortByDirection.desc
        },
        onClick: function onClick(e) {
          return sortByConfig.onSortChange && sortByConfig.onSortChange(e, SortByDirection.desc);
        }
      }] : []);

      return /*#__PURE__*/React.createElement(Toolbar, _extends({}, props, {
        className: "".concat(className || '', " ins-c-primary-toolbar"),
        toggleIsExpanded: toggleIsExpanded,
        id: id || 'ins-primary-data-toolbar'
      }), /*#__PURE__*/React.createElement(ToolbarContent, null, (expandAll || bulkSelect || filterConfig || dedicatedAction) && /*#__PURE__*/React.createElement(ToolbarGroup, {
        className: "ins-c-primary-toolbar__group-filter pf-m-spacer-md pf-m-space-items-lg",
        variant: "filter-group"
      }, expandAll && /*#__PURE__*/React.createElement(ToolbarItem, null, /*#__PURE__*/React.isValidElement(expandAll) ? expandAll : /*#__PURE__*/React.createElement(Button, {
        variant: "plain",
        "aria-label": "".concat(expandAll.isAllExpanded ? 'Collapse' : 'Expand', " all"),
        onClick: function onClick(e) {
          return expandAll.onClick(e, !expandAll.isAllExpanded);
        }
      }, /*#__PURE__*/React.createElement(ToolbarExpandIconWrapper, null, expandAll.isAllExpanded ? /*#__PURE__*/React.createElement(AngleDownIcon, null) : /*#__PURE__*/React.createElement(AngleRightIcon, null)))), bulkSelect && /*#__PURE__*/React.createElement(ToolbarItem, null, /*#__PURE__*/React.isValidElement(bulkSelect) ? bulkSelect : /*#__PURE__*/React.createElement(BulkSelect, bulkSelect)), filterConfig && /*#__PURE__*/React.createElement(ToolbarItem, {
        className: "ins-c-primary-toolbar__filter"
      }, /*#__PURE__*/React.isValidElement(filterConfig) ? filterConfig : /*#__PURE__*/React.createElement(ConditionalFilter, _extends({
        useMobileLayout: useMobileLayout
      }, filterConfig))), dedicatedAction && /*#__PURE__*/React.createElement(ToolbarItem, null, dedicatedAction)), /*#__PURE__*/React.isValidElement(actionsConfig) ? actionsConfig : (actionsConfig && actionsConfig.actions && actionsConfig.actions.length > 0 || sortByConfig || exportConfig) && /*#__PURE__*/React.createElement(Actions, _extends({}, actionsConfig || {}, {
        exportConfig: exportConfig,
        overflowActions: overflowActions
      })), sortByConfig && /*#__PURE__*/React.createElement(ToolbarItem, {
        className: "ins-c-primary-toolbar__sort-by"
      }, /*#__PURE__*/React.isValidElement(sortByConfig) ? sortByConfig : /*#__PURE__*/React.createElement(SortBy, sortByConfig)), children, pagination && /*#__PURE__*/React.createElement(ToolbarItem, {
        className: "ins-c-primary-toolbar__pagination"
      }, /*#__PURE__*/React.isValidElement(pagination) ? pagination : /*#__PURE__*/React.createElement(Pagination, _extends({
        isCompact: true
      }, pagination)))), activeFiltersConfig && /*#__PURE__*/React.isValidElement(activeFiltersConfig) ? /*#__PURE__*/React.createElement(ToolbarContent, null, /*#__PURE__*/React.createElement(ToolbarItem, null, activeFiltersConfig)) : activeFiltersConfig !== undefined && (activeFiltersConfig.filters.length > 0 || activeFiltersConfig.showDeleteButton === true) && /*#__PURE__*/React.createElement(ToolbarContent, null, /*#__PURE__*/React.createElement(ToolbarItem, null, /*#__PURE__*/React.createElement(FilterChips, activeFiltersConfig))));
    }
  }]);

  return PrimaryToolbar;
}(Component);

PrimaryToolbar.propTypes = {
  id: PropTypes.oneOfType([PropTypes.number, PropTypes.string]),
  className: PropTypes.string,
  toggleIsExpanded: PropTypes.func,

  /** @reference [BulkSelect props](/components/BulkSelect) */
  bulkSelect: PropTypes.shape(BulkSelect.propTypes),

  /** @reference [ConditionalFilter props](/components/ConditionalFilter) */
  filterConfig: PropTypes.shape(ConditionalFilter.propTypes),
  dedicatedAction: PropTypes.node,

  /** @reference [PF pagination props](https://www.patternfly.org/v4/components/pagination#pagination) */
  pagination: PropTypes.shape(Pagination.propTypes),

  /** @reference [SortBy props](/components/SortBy) */
  sortByConfig: PropTypes.shape(SortBy.propTypes),

  /** @reference [DownloadButton props](/components/DownloadButton) */
  exportConfig: PropTypes.shape(DownloadButton.propTypes),

  /** @reference [FilterChips props](/components/FilterChips) */
  activeFiltersConfig: PropTypes.shape(FilterChips.propTypes),
  children: PropTypes.node,
  actionsConfig: PropTypes.shape({
    actions: Actions.propTypes.actions,
    dropdownProps: Actions.propTypes.dropdownProps,
    onSelect: Actions.propTypes.onSelect
  }),
  expandAll: PropTypes.oneOfType([PropTypes.node, PropTypes.shape({
    onClick: PropTypes.func,
    isAllExpanded: PropTypes.bool
  })]),

  /** Use PF [toolbar toggle component for conditional filter](https://www.patternfly.org/v4/components/toolbar/react/component-managed-toggle-groups/) */
  useMobileLayout: PropTypes.bool
};
export default PrimaryToolbar;