import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

import React, { Fragment } from 'react';
import { Pagination } from "@patternfly/react-core/dist/esm/components/Pagination/Pagination.js";
import { Bullseye } from "@patternfly/react-core/dist/esm/layouts/Bullseye/Bullseye.js";
import { EmptyState } from "@patternfly/react-core/dist/esm/components/EmptyState/EmptyState.js";
import { EmptyStateVariant } from "@patternfly/react-core/dist/esm/components/EmptyState/EmptyState.js";
import { Title } from "@patternfly/react-core/dist/esm/components/Title/Title.js";
import { EmptyStateBody } from "@patternfly/react-core/dist/esm/components/EmptyState/EmptyStateBody.js";
import { PropTypes } from 'prop-types';
import { Table, TableHeader, TableBody } from '@patternfly/react-table';
import { EmptyTable } from '../EmptyTable';
import { TableToolbar } from '../TableToolbar';
import { PrimaryToolbar } from '../PrimaryToolbar';
import { Skeleton } from '../Skeleton';
import { SkeletonTable } from '../SkeletonTable';

var TableWithFilter = function TableWithFilter(_ref) {
  var rows = _ref.rows,
      _onSelect = _ref.onSelect,
      selected = _ref.selected,
      onUpdateData = _ref.onUpdateData,
      pagination = _ref.pagination,
      loaded = _ref.loaded,
      calculateChecked = _ref.calculateChecked,
      unique = _ref.unique,
      filters = _ref.filters,
      primaryToolbarProps = _ref.primaryToolbarProps,
      children = _ref.children,
      title = _ref.title,
      systemName = _ref.systemName,
      columns = _ref.columns,
      tableProps = _ref.tableProps,
      entityName = _ref.entityName,
      bulkSelect = _ref.bulkSelect;

  var onRowSelect = function onRowSelect(_ref2) {
    var isSelected = _ref2.isSelected,
        rowId = _ref2.rowId;
    var currRow = rows === null || rows === void 0 ? void 0 : rows[rowId];

    if (currRow) {
      _onSelect(isSelected ? [].concat(_toConsumableArray(selected), [currRow]) : selected.filter(function (_ref3) {
        var id = _ref3.id;
        return id !== currRow.id;
      }));
    }
  };

  return /*#__PURE__*/React.createElement(Fragment, null, onUpdateData && /*#__PURE__*/React.createElement(PrimaryToolbar, _extends({}, _onSelect && pagination && {
    bulkSelect: _objectSpread({
      count: selected === null || selected === void 0 ? void 0 : selected.length,
      onSelect: function onSelect(isSelected) {
        if (isSelected) {
          _onSelect(unique === null || unique === void 0 ? void 0 : unique([].concat(_toConsumableArray(rows), _toConsumableArray(selected))));
        } else {
          _onSelect(selected.filter(function (_ref4) {
            var id = _ref4.id;
            return !rows.find(function (_ref5) {
              var rowId = _ref5.id;
              return rowId === id;
            });
          }));
        }
      },
      checked: loaded && (calculateChecked === null || calculateChecked === void 0 ? void 0 : calculateChecked(rows, selected)),
      items: [{
        title: 'Select none (0)',
        onClick: function onClick() {
          return _onSelect([]);
        }
      }, _objectSpread({}, loaded && (rows === null || rows === void 0 ? void 0 : rows.length) > 0 ? {
        title: "Select page (".concat(rows.length, ")"),
        onClick: function onClick() {
          return _onSelect(unique([].concat(_toConsumableArray(rows), _toConsumableArray(selected))));
        }
      } : {})]
    }, bulkSelect || {})
  }, filters && {
    filterConfig: {
      items: filters
    }
  }, {
    pagination: loaded ? _objectSpread(_objectSpread({}, pagination || {}), {}, {
      itemCount: pagination === null || pagination === void 0 ? void 0 : pagination.count,
      onSetPage: function onSetPage(_e, page) {
        return onUpdateData(_objectSpread(_objectSpread({}, pagination), {}, {
          page: page
        }));
      },
      onPerPageSelect: function onPerPageSelect(_e, perPage) {
        return onUpdateData(_objectSpread(_objectSpread({}, pagination), {}, {
          page: 1,
          perPage: perPage
        }));
      }
    }) : /*#__PURE__*/React.createElement(Skeleton, {
      size: "lg"
    })
  }, primaryToolbarProps)), children, loaded ? /*#__PURE__*/React.createElement(Table, _extends({
    "aria-label": title || "".concat(systemName, " ").concat(entityName),
    variant: "compact",
    className: "ins-c-tag-modal__table",
    cells: columns,
    rows: rows !== null && rows !== void 0 && rows.length ? rows : [{
      cells: [{
        title: /*#__PURE__*/React.createElement(EmptyTable, null, /*#__PURE__*/React.createElement(Bullseye, null, /*#__PURE__*/React.createElement(EmptyState, {
          variant: EmptyStateVariant.full
        }, /*#__PURE__*/React.createElement(Title, {
          headingLevel: "h5",
          size: "lg"
        }, "No ", entityName, " found"), /*#__PURE__*/React.createElement(EmptyStateBody, null, "This filter criteria matches no ", entityName, ". ", /*#__PURE__*/React.createElement("br", null), " Try changing your filter settings.")))),
        props: {
          colSpan: columns.length
        }
      }]
    }]
  }, _onSelect && (rows === null || rows === void 0 ? void 0 : rows.length) && {
    onSelect: function onSelect(_event, isSelected, rowId) {
      return onRowSelect({
        isSelected: isSelected,
        rowId: rowId
      });
    }
  }, tableProps), /*#__PURE__*/React.createElement(TableHeader, null), /*#__PURE__*/React.createElement(TableBody, null)) : /*#__PURE__*/React.createElement(SkeletonTable, {
    columns: columns,
    rowSize: (pagination === null || pagination === void 0 ? void 0 : pagination.perPage) || 10
  }), onUpdateData && pagination && loaded && /*#__PURE__*/React.createElement(TableToolbar, {
    isFooter: true,
    className: "ins-c-inventory__table--toolbar"
  }, /*#__PURE__*/React.createElement(Pagination, {
    itemCount: pagination === null || pagination === void 0 ? void 0 : pagination.count,
    perPage: pagination === null || pagination === void 0 ? void 0 : pagination.perPage,
    page: (pagination === null || pagination === void 0 ? void 0 : pagination.page) || 0,
    variant: "bottom",
    onSetPage: function onSetPage(_event, page) {
      return onUpdateData(_objectSpread(_objectSpread({}, pagination), {}, {
        page: page
      }));
    },
    onPerPageSelect: function onPerPageSelect(_event, perPage) {
      return onUpdateData(_objectSpread(_objectSpread({}, pagination), {}, {
        page: 1,
        perPage: perPage
      }));
    }
  })));
};

TableWithFilter.propTypes = {
  entityName: PropTypes.string,
  loaded: PropTypes.bool,
  systemName: PropTypes.string,
  rows: PropTypes.array,
  selected: PropTypes.array,
  columns: PropTypes.array,
  filters: PropTypes.array,
  pagination: PropTypes.shape({
    count: PropTypes.number,
    page: PropTypes.number,
    perPage: PropTypes.number
  }),
  primaryToolbarProps: PropTypes.object,
  tableProps: PropTypes.object,
  children: PropTypes.node,
  title: PropTypes.node,
  calculateChecked: PropTypes.func,
  unique: PropTypes.func,
  onSelect: PropTypes.func,
  onUpdateData: PropTypes.func,
  bulkSelect: PropTypes.any
};
TableWithFilter.defaultProps = {
  entityName: 'tags'
};
export default TableWithFilter;