import { K8sResourceCommon, Selector } from 'console-sdk-ai-lib';
import { StatusCondition } from './shared';
export declare type ClusterDeploymentStatusConditionType = 'ClusterInstallCompleted' | 'ClusterInstallFailed' | 'ClusterInstallStopped' | 'ProvisionFailed' | 'ProvisionStopped' | 'RequirementsMet' | 'AuthenticationFailure' | 'ClusterInstallRequirementsMet' | 'InstallImagesNotResolved' | 'InstallerImageResolutionFailed' | 'RelocationFailed' | 'AWSPrivateLinkFailed' | 'AWSPrivateLinkReady' | 'ActiveAPIURLOverride' | 'ControlPlaneCertificateNotFound' | 'DNSNotReady' | 'DeprovisionLaunchError' | 'Hibernating' | 'IngressCertificateNotFound' | 'InstallLaunchError' | 'SyncSetFailed' | 'Unreachable';
export declare type ClusterInstallRef = {
    group: string;
    kind: string;
    version: string;
    name: string;
};
export declare type ClusterDeploymentK8sResource = K8sResourceCommon & {
    spec?: {
        baseDomain: string;
        clusterInstallRef: ClusterInstallRef;
        clusterName: string;
        platform: {
            agentBareMetal: {
                agentSelector?: Selector;
            };
        };
        pullSecretRef?: {
            name: string;
        };
    };
    status?: {
        installVersion?: string;
        installedTimestamp?: string;
        installStartedTimestamp: string;
        webConsoleURL?: string;
        apiURL?: string;
        conditions?: StatusCondition<ClusterDeploymentStatusConditionType>[];
    };
};
