import { K8sResourceCommon, Selector } from 'console-sdk-ai-lib';
import { StatusCondition } from './shared';
export declare type InfraEnvStatusConditionType = 'ImageCreated';
export declare type InfraEnvK8sResource = K8sResourceCommon & {
    spec?: {
        agentLabels?: {
            [key: string]: string;
        };
        clusterRef?: {
            name: string;
            namespace: string;
        };
        pullSecretRef?: {
            name: string;
        };
        sshAuthorizedKey?: string;
        proxy?: {
            httpProxy: string;
            httpsProxy: string;
            noProxy: string;
        };
        nmStateConfigLabelSelector?: Selector;
    };
    status?: {
        agentLabelSelector?: Selector;
        conditions?: StatusCondition<InfraEnvStatusConditionType>[];
        isoDownloadURL?: string;
    };
};
