import * as React from 'react';
export interface StaticFieldProps {
    name: string;
    label: string;
    helperText?: React.ReactNode;
    helperTextInvalid?: React.ReactNode;
    isRequired?: boolean;
    isValid?: boolean;
}
export declare const StaticField: React.FC<StaticFieldProps>;
/**
 * Static Formik field which sets value prop as formik field value
 */
declare type FormikStaticFieldProps = {
    value: string;
} & StaticFieldProps;
export declare const FormikStaticField: React.FC<FormikStaticFieldProps>;
/**
 * Simplified form component for rendering static text.
 * Does not reflect field value from formik.
 */
export declare const StaticTextField: React.FC<StaticFieldProps>;
export {};
