import { AxiosPromise, AxiosRequestConfig } from 'axios';
import { Cluster, ClusterCreateParams, Host, ClusterUpdateParams, ImageCreateParams, Credentials, Presigned, EventList, Event, LogsType, ClusterDefaultConfig, PreflightHardwareRequirements, PlatformType } from '../../common/api/types';
export declare const getClusters: () => AxiosPromise<Cluster[]>;
export declare const getClustersDefaultConfiguration: () => AxiosPromise<ClusterDefaultConfig>;
export declare const getCluster: (id: string) => AxiosPromise<Cluster>;
export declare const getClustersByOpenshiftId: (openshiftId: string) => AxiosPromise<Cluster[]>;
export declare const postCluster: (params: ClusterCreateParams) => AxiosPromise<Cluster>;
export declare const patchCluster: (id: string, params: ClusterUpdateParams) => AxiosPromise<Cluster>;
export declare const deleteCluster: (id: string) => AxiosPromise<void>;
export declare const getClusterHosts: (id: string) => AxiosPromise<Host[]>;
export declare const enableClusterHost: (clusterId: string, hostId: string) => AxiosPromise<Cluster>;
export declare const disableClusterHost: (clusterId: string, hostId: string) => AxiosPromise<Cluster>;
export declare const resetClusterHost: (clusterId: string, hostId: string) => AxiosPromise<Host>;
export declare const deleteClusterHost: (clusterId: string, hostId: string) => AxiosPromise<void>;
export declare const postInstallCluster: (clusterId: string) => AxiosPromise<Cluster>;
export declare const postResetCluster: (clusterId: string) => AxiosPromise<Cluster>;
export declare const postCancelInstallation: (clusterId: string) => AxiosPromise<Cluster>;
export declare const createClusterDownloadsImage: (id: string, params: ImageCreateParams, axiosOptions: AxiosRequestConfig) => AxiosPromise<Cluster>;
declare type getPresignedFileUrlProps = {
    clusterId: string;
    fileName: 'logs' | 'kubeconfig' | 'kubeconfig-noingress';
    hostId?: string;
    logsType?: LogsType;
};
export declare const getPresignedFileUrl: ({ clusterId, fileName, hostId, logsType, }: getPresignedFileUrlProps) => AxiosPromise<Presigned>;
export declare const getClusterFileDownload: (clusterID: Cluster['id'], fileName: string) => Promise<import("axios").AxiosResponse<Blob, any>>;
export declare const getClusterDownloadsImageUrl: (clusterId: string) => string;
export declare const getClusterCredentials: (clusterID: string) => AxiosPromise<Credentials>;
export declare const getHostLogsDownloadUrl: (hostId: string, clusterId?: string | undefined) => string;
export declare const getClusterLogsDownloadUrl: (clusterId: string) => string;
export declare const getEvents: (clusterID: Event['clusterId'], hostID: Event['hostId']) => AxiosPromise<EventList>;
export declare const getClusterPreflightRequirements: (clusterID: Cluster['id']) => AxiosPromise<PreflightHardwareRequirements>;
export declare const getClusterSupportedPlatforms: (clusterID: Cluster['id']) => AxiosPromise<PlatformType[]>;
export {};
