import { Tooltip } from "@patternfly/react-core/dist/esm/components/Tooltip/Tooltip.js";
import QuestionIcon from "@patternfly/react-icons/dist/esm/icons/question-icon";
import SecurityIcon from "@patternfly/react-icons/dist/esm/icons/security-icon";
import propTypes from 'prop-types';
import React from 'react';
import { impactList } from './consts';

var Shield = function Shield(_ref) {
  var _impactList$impact;

  var impact = _ref.impact,
      hasLabel = _ref.hasLabel,
      hasTooltip = _ref.hasTooltip,
      size = _ref.size;
  var attributes = (_impactList$impact = impactList === null || impactList === void 0 ? void 0 : impactList[impact]) !== null && _impactList$impact !== void 0 ? _impactList$impact : impactList.Unknown;
  var badgeProps = {
    'aria-hidden': 'false',
    'aria-label': attributes.title,
    color: attributes.color,
    size: size
  };
  var badge = attributes.title === 'Unknown' ? /*#__PURE__*/React.createElement(QuestionIcon, badgeProps) : /*#__PURE__*/React.createElement(SecurityIcon, badgeProps);
  var body = /*#__PURE__*/React.createElement("span", null, badge, " ", hasLabel && attributes.title);
  return /*#__PURE__*/React.createElement("span", null, hasTooltip ? /*#__PURE__*/React.createElement(Tooltip, {
    content: /*#__PURE__*/React.createElement("div", null, attributes.message),
    position: 'bottom'
  }, body) : body);
};

Shield.defaultProps = {
  impact: 'N/A',
  hasLabel: false,
  size: 'sm',
  hasTooltip: true
};
Shield.propTypes = {
  impact: propTypes.oneOfType([propTypes.string, propTypes.number]),
  hasLabel: propTypes.bool,
  size: propTypes.string,
  // sm, md, lg and xl,
  label: propTypes.bool,
  hasTooltip: propTypes.bool
};
export default Shield;