import * as React from 'react';
import { editor } from 'monaco-editor/esm/vs/editor/editor.api';
export declare enum Language {
    abap = "abap",
    aes = "aes",
    apex = "apex",
    azcli = "azcli",
    bat = "bat",
    bicep = "bicep",
    c = "c",
    cameligo = "cameligo",
    clojure = "clojure",
    coffeescript = "coffeescript",
    cpp = "cpp",
    csharp = "csharp",
    csp = "csp",
    css = "css",
    dart = "dart",
    dockerfile = "dockerfile",
    ecl = "ecl",
    elixir = "elixir",
    fsharp = "fsharp",
    go = "go",
    graphql = "graphql",
    handlebars = "handlebars",
    hcl = "hcl",
    html = "html",
    ini = "ini",
    java = "java",
    javascript = "javascript",
    json = "json",
    julia = "julia",
    kotlin = "kotlin",
    less = "less",
    lexon = "lexon",
    liquid = "liquid",
    lua = "lua",
    m3 = "m3",
    markdown = "markdown",
    mips = "mips",
    msdax = "msdax",
    mysql = "mysql",
    'objective-c' = "objective-c",
    pascal = "pascal",
    pascaligo = "pascaligo",
    perl = "perl",
    pgsql = "pgsql",
    php = "php",
    plaintext = "plaintext",
    postiats = "postiats",
    powerquery = "powerquery",
    powershell = "powershell",
    pug = "pug",
    python = "python",
    r = "r",
    razor = "razor",
    redis = "redis",
    redshift = "redshift",
    restructuredtext = "restructuredtext",
    ruby = "ruby",
    rust = "rust",
    sb = "sb",
    scala = "scala",
    scheme = "scheme",
    scss = "scss",
    shell = "shell",
    sol = "sol",
    sql = "sql",
    st = "st",
    swift = "swift",
    systemverilog = "systemverilog",
    tcl = "tcl",
    twig = "twig",
    typescript = "typescript",
    vb = "vb",
    verilog = "verilog",
    xml = "xml",
    yaml = "yaml"
}
export interface CodeEditorProps extends Omit<React.HTMLProps<HTMLDivElement>, 'onChange'> {
    /** additional classes added to the code editor */
    className?: string;
    /** code displayed in code editor */
    code?: string;
    /** language displayed in the editor */
    language?: Language;
    /** Flag indicating the editor is styled using monaco's dark theme */
    isDarkTheme?: boolean;
    /** Width of code editor. Defaults to 100% */
    width?: string;
    /** Flag indicating the editor is displaying line numbers */
    isLineNumbersVisible?: boolean;
    /** Flag indicating the editor is read only */
    isReadOnly?: boolean;
    /** Height of code editor. Defaults to 100% */
    height?: string;
    /** Function which fires each time the code changes in the code editor */
    onChange?: (value?: string, event?: any) => void;
    /** The loading screen before the editor will be loaded. Defaults 'loading...' */
    loading?: React.ReactNode;
    /** Content to display in space of the code editor when there is no code to display */
    emptyState?: React.ReactNode;
    /** Name of the file if user downloads code to local file */
    downloadFileName?: string;
    /** Flag to add upload button to code editor actions. Also makes the code editor accept a file using drag and drop */
    isUploadEnabled?: boolean;
    /** Flag to add download button to code editor actions */
    isDownloadEnabled?: boolean;
    /** Flag to add copy button to code editor actions */
    isCopyEnabled?: boolean;
    /** Flag to include a label indicating the currently configured editor language */
    isLanguageLabelVisible?: boolean;
    /** Accessibly label for the copy button */
    copyButtonAriaLabel?: string;
    /** Text to display in the tooltip on the copy button before text is copied */
    copyButtonToolTipText?: string;
    /** Text to display in the tooltip on the copy button after code copied to clipboard */
    copyButtonSuccessTooltipText?: string;
    /** Accessible label for the upload button */
    uploadButtonAriaLabel?: string;
    /** Text to display in the tooltip on the upload button */
    uploadButtonToolTipText?: string;
    /** Accessible label for the download button */
    downloadButtonAriaLabel?: string;
    /** Text to display in the tooltip on the download button */
    downloadButtonToolTipText?: string;
    /** The delay before tooltip fades after code copied */
    toolTipCopyExitDelay: number;
    /** The entry and exit delay for all tooltips */
    toolTipDelay: number;
    /** The max width of the tooltips on all button */
    toolTipMaxWidth: string;
    /** The position of tooltips on all buttons */
    toolTipPosition: 'auto' | 'top' | 'bottom' | 'left' | 'right';
    /** A single node or array of nodes - ideally CodeEditorControls - to display above code editor */
    customControls?: React.ReactNode | React.ReactNode[];
    /** Callback which fires after the code editor is mounted containing
     * a reference to the monaco editor and the monaco instance */
    onEditorDidMount?: (editor: any, monaco: any) => void;
    /** Flag to add the minimap to the code editor */
    isMinimapVisible?: boolean;
    /** Flag to show the editor */
    showEditor?: boolean;
    /**
     * Refer to Monaco interface {monaco.editor.IStandaloneEditorConstructionOptions}.
     */
    options?: editor.IStandaloneEditorConstructionOptions;
    /**
     * Refer to Monaco interface {monaco.editor.IEditorOverrideServices}.
     */
    overrideServices?: editor.IEditorOverrideServices;
}
interface CodeEditorState {
    value: string;
    filename: string;
    isLoading: boolean;
    showEmptyState: boolean;
    copied: boolean;
}
export declare class CodeEditor extends React.Component<CodeEditorProps, CodeEditorState> {
    static displayName: string;
    private editor;
    private wrapperRef;
    timer: number;
    static defaultProps: CodeEditorProps;
    static getExtensionFromLanguage(language: Language): string;
    constructor(props: CodeEditorProps);
    onChange: (value: string, event: any) => void;
    componentDidUpdate(prevProps: CodeEditorProps): void;
    componentDidMount(): void;
    componentWillUnmount(): void;
    handleGlobalKeys: (event: KeyboardEvent) => void;
    editorDidMount: (editor: any, monaco: any) => void;
    handleFileChange: (value: string, filename: string) => void;
    handleFileReadStarted: () => void;
    handleFileReadFinished: () => void;
    readFile(fileHandle: Blob): Promise<unknown>;
    onDropAccepted: (acceptedFiles: File[]) => void;
    onDropRejected: (rejectedFiles: File[]) => void;
    copyCode: () => void;
    download: () => void;
    toggleEmptyState: () => void;
    render(): JSX.Element;
}
export {};
//# sourceMappingURL=CodeEditor.d.ts.map