var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import React, { Component, Fragment } from 'react';
import PropTypes from 'prop-types';
import { TextInput } from '@patternfly/react-core';
import { SearchIcon } from '@patternfly/react-icons';
import './conditional-filter.css';
var Text = (function (_super) {
    __extends(Text, _super);
    function Text() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.state = {
            stateValue: '',
        };
        _this.onChangeValue = function (e, value) {
            _this.setState({
                stateValue: value,
            });
        };
        return _this;
    }
    Text.prototype.render = function () {
        var _a = this.props, value = _a.value, onChange = _a.onChange, onSubmit = _a.onSubmit, id = _a.id, icon = _a.icon, className = _a.className, isDisabled = _a.isDisabled, props = __rest(_a, ["value", "onChange", "onSubmit", "id", "icon", "className", "isDisabled"]);
        var Icon = icon || SearchIcon;
        var stateValue = this.state.stateValue;
        var changeCallback = onChange ? onChange : this.onChangeValue;
        return (React.createElement(Fragment, null,
            React.createElement(TextInput, __assign({}, props, { className: "ins-c-conditional-filter ".concat(className || ''), id: id, isDisabled: isDisabled, value: onChange ? value : stateValue, onChange: function (_inputValue, e) { return changeCallback(e, e.target.value); }, "widget-type": "InsightsInput", onKeyDown: function (e) { return e.key === 'Enter' && onSubmit(e, value || stateValue); }, "data-ouia-component-type": "PF4/TextInput", ouiaId: "ConditionalFilter" })),
            React.createElement(Icon, { size: "sm", className: "ins-c-search-icon" })));
    };
    return Text;
}(Component));
Text.propTypes = {
    value: PropTypes.string,
    placeholder: PropTypes.string,
    onChange: PropTypes.func,
    onSubmit: PropTypes.func,
    isDisabled: PropTypes.bool,
    'aria-label': PropTypes.string,
    id: PropTypes.string,
    icon: PropTypes.elementType,
    className: PropTypes.string,
};
Text.defaultProps = {
    value: '',
    onSubmit: function () { return undefined; },
    isDisabled: false,
    'aria-label': 'text input',
};
export default Text;
//# sourceMappingURL=TextFilter.js.map