"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireWildcard(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _iconsReact = require("@carbon/icons-react");

var _carbonComponents = require("carbon-components");

var _Copy = _interopRequireDefault(require("../Copy"));

var _Button = _interopRequireDefault(require("../Button"));

var _CopyButton = _interopRequireDefault(require("../CopyButton"));

var _uniqueId = _interopRequireDefault(require("../../tools/uniqueId"));

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var prefix = _carbonComponents.settings.prefix;

function CodeSnippet(_ref) {
  var _classNames;

  var className = _ref.className,
      type = _ref.type,
      children = _ref.children,
      feedback = _ref.feedback,
      onClick = _ref.onClick,
      ariaLabel = _ref.ariaLabel,
      copyLabel = _ref.copyLabel,
      copyButtonDescription = _ref.copyButtonDescription,
      light = _ref.light,
      showMoreText = _ref.showMoreText,
      showLessText = _ref.showLessText,
      rest = _objectWithoutProperties(_ref, ["className", "type", "children", "feedback", "onClick", "ariaLabel", "copyLabel", "copyButtonDescription", "light", "showMoreText", "showLessText"]);

  var _useState = (0, _react.useState)(false),
      _useState2 = _slicedToArray(_useState, 2),
      expandedCode = _useState2[0],
      setExpandedCode = _useState2[1];

  var _useState3 = (0, _react.useState)(false),
      _useState4 = _slicedToArray(_useState3, 2),
      shouldShowMoreLessBtn = _useState4[0],
      setShouldShowMoreLessBtn = _useState4[1];

  var _useRef = (0, _react.useRef)((0, _uniqueId.default)()),
      uid = _useRef.current;

  var codeContentRef = (0, _react.useRef)();
  (0, _react.useLayoutEffect)(function () {
    if (codeContentRef.current) {
      var _codeContentRef$curre = codeContentRef.current.getBoundingClientRect(),
          height = _codeContentRef$curre.height;

      setShouldShowMoreLessBtn(type === 'multi' && height > 255);
    }
  }, [children, type]);
  var codeSnippetClasses = (0, _classnames.default)(className, (_classNames = {}, _defineProperty(_classNames, "".concat(prefix, "--snippet"), true), _defineProperty(_classNames, "".concat(prefix, "--snippet--").concat(type), type), _defineProperty(_classNames, "".concat(prefix, "--snippet--expand"), expandedCode), _defineProperty(_classNames, "".concat(prefix, "--snippet--light"), light), _classNames));
  var expandCodeBtnText = expandedCode ? showLessText : showMoreText;

  if (type === 'inline') {
    return _react.default.createElement(_Copy.default, _extends({}, rest, {
      onClick: onClick,
      "aria-label": copyLabel || ariaLabel,
      "aria-describedby": uid,
      className: codeSnippetClasses,
      feedback: feedback
    }), _react.default.createElement("code", {
      id: uid
    }, children));
  }

  return _react.default.createElement("div", _extends({}, rest, {
    className: codeSnippetClasses
  }), _react.default.createElement("div", {
    role: "textbox",
    tabIndex: 0,
    className: "".concat(prefix, "--snippet-container"),
    "aria-label": ariaLabel || copyLabel || 'code-snippet'
  }, _react.default.createElement("code", null, _react.default.createElement("pre", {
    ref: codeContentRef
  }, children))), _react.default.createElement(_CopyButton.default, {
    onClick: onClick,
    feedback: feedback,
    iconDescription: copyButtonDescription
  }), shouldShowMoreLessBtn && _react.default.createElement(_Button.default, {
    kind: "ghost",
    size: "small",
    className: "".concat(prefix, "--snippet-btn--expand"),
    onClick: function onClick() {
      return setExpandedCode(!expandedCode);
    }
  }, _react.default.createElement("span", {
    className: "".concat(prefix, "--snippet-btn--text")
  }, expandCodeBtnText), _react.default.createElement(_iconsReact.ChevronDown16, {
    "aria-label": expandCodeBtnText,
    className: "".concat(prefix, "--icon-chevron--down ").concat(prefix, "--snippet__icon"),
    name: "chevron--down",
    role: "img"
  })));
}

CodeSnippet.propTypes = {
  /**
   * Provide the type of Code Snippet
   */
  type: _propTypes.default.oneOf(['single', 'inline', 'multi']),

  /**
   * Specify an optional className to be applied to the container node
   */
  className: _propTypes.default.string,

  /**
   * Provide the content of your CodeSnippet as a string
   */
  children: _propTypes.default.string,

  /**
   * Specify the string displayed when the snippet is copied
   */
  feedback: _propTypes.default.string,

  /**
   * Specify the description for the Copy Button
   */
  copyButtonDescription: _propTypes.default.string,

  /**
   * An optional handler to listen to the `onClick` even fired by the Copy
   * Button
   */
  onClick: _propTypes.default.func,

  /**
   * Specify a label to be read by screen readers on the containing <textbox>
   * node
   */
  copyLabel: _propTypes.default.string,

  /**
   * Specify a label to be read by screen readers on the containing <textbox>
   * node
   */
  ariaLabel: _propTypes.default.string,

  /**
   * Specify a string that is displayed when the Code Snippet text is more
   * than 15 lines
   */
  showMoreText: _propTypes.default.string,

  /**
   * Specify a string that is displayed when the Code Snippet has been
   * interacted with to show more lines
   */
  showLessText: _propTypes.default.string,

  /**
   * Specify whether you are using the light variant of the Code Snippet,
   * typically used for inline snippet to display an alternate color
   */
  light: _propTypes.default.bool
};
CodeSnippet.defaultProps = {
  type: 'single',
  showMoreText: 'Show more',
  showLessText: 'Show less'
};
var _default = CodeSnippet;
exports.default = _default;