#!/bin/bash
# Licensed Materials - Property of IBM
# (c) Copyright IBM Corporation 2020. All Rights Reserved.
# Note to U.S. Government Users Restricted Rights:
# Use, duplication or disclosure restricted by GSA ADP Schedule
# Contract with IBM Corp.
# Copyright (c) 2020 Red Hat, Inc.
set -e

echo "Login hub to get SERVICEACCT_TOKEN"
export OC_CLUSTER_URL=$API_SERVER_URL
export OC_CLUSTER_USER=$SELENIUM_USER
export OC_CLUSTER_PASS=$SELENIUM_PASSWORD 
make oc/login
export SERVICEACCT_TOKEN=`${BUILD_HARNESS_PATH}/vendor/oc whoami --show-token`
echo "SERVICEACCT_TOKEN=$SERVICEACCT_TOKEN"

export NODE_ENV=development 
make build-dev
npm run start:instrument &>/dev/null &
sleep 10
npm run test:e2e-headless

# kill the node process to let nyc generate coverage report
ps -ef | grep 'node app.js' | grep -v grep | awk '{print $2}' | xargs kill
sleep 10

sed -i 's|SF:|SF:'"$(pwd)"/'|g' test-output/server/coverage/lcov.info
