/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2017, 2019. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************
/* Copyright (c) 2020 Red Hat, Inc. */
'use strict'
const express = require('express'),
      router = express.Router(),
      config = require('../config')

const status = require('./status'),
      ui = require('./ui'),
      welcomeController = require('./welcome'),
      inspect = require('security-middleware')

const redirectCSRF = (req, res, next) => {
  // do a redirect if _csrf doesn't exist on cookie
  // this would force it to be set on next call
  // https://github.com/open-cluster-management/backlog/issues/6798
  if (!req.cookies['_csrf']) {
    res.redirect(req.path)
  } else {
    next()
  }
}

router.all(['/', '/status', '/livenessProbe', '/readinessProbe'], status)
router.all('/multicloud/welcome*', inspect.ui(), redirectCSRF, welcomeController)
router.use(config.get('headerContextPath'), ui)

module.exports = router
