/* Copyright (c) 2020 Red Hat, Inc. */

'use strict'

const express = require('express'),
      router = express.Router(),
      acmVersion = require('../../lib/server/acm-version')

router.get('/version', (req, res) => {

  acmVersion.getACMVersion(req, (err, response) => {
    if (err) {
      if (err.message){
        res.statusMessage = err.message
      }
      return res.status(500).end()
    }

    res.set('Content-Type', 'application/json')
    return res.send(response.body)
  })
})

module.exports = router
