/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2019. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/

const express = require('express')
const router = express.Router()
const graphqlClient = require('../../lib/server/graphql-client')

router.post('/', (req, res) => {
  graphqlClient.graphqlService(req, (err, response) => {
    if (err) {
      return res.status(500).send(err.details)
    }
    return response && response.body && res.send(response.body)
  })
})

module.exports = router
