/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2017, 2019. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
/* Copyright (c) 2020 Red Hat, Inc. */
'use strict'

const express = require('express'),
      router = express.Router(),
      inspect = require('security-middleware')

//controllers
const k8sController = require('./k8s'),
      consoleApi = require('./api'),
      acmVersionController = require('./acmVersion'),
      logoutController = require('./logout'),
      app = require('./app')

const graphqlController = require('./graphqlservice')

router.all('/api/*', inspect.ui(), consoleApi)
router.all('/version', acmVersionController)
router.all('/kubernetes/*', k8sController)
router.all('/logout/*', logoutController)
router.all('/graphql', graphqlController)
router.all(['/', '/*'], inspect.ui(), app)

module.exports = router
