/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2017, 2019. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
/* Copyright (c) 2020 Red Hat, Inc. */
'use strict'

const express = require('express'),
      async = require('async'),
      router = express.Router(),
      k8sClient = require('../../lib/server/k8s-client'),
      ACTION_API_URL = '/apis/action.open-cluster-management.io/v1beta1',
      _ = require('lodash')

const post = (req, res, cb) => {
  k8sClient.post(req, (err, body) => {
    if (err) {
      if (err.message) {
        res.statusMessage = err.message.replace(/\r?\n|\r/, '')
      }
      return res.status(err.statusCode || 500).end()
    }

    res.set('Content-Type', 'application/json')

    if (!cb) {
      return res.send(body)
    }

    cb(res, body)
  })
}

const get = (req, res, cb) => {
  k8sClient.getWithReq(req, (err, body) => {
    if (err) {
      if (err.message) {
        res.statusMessage = err.message
      }
      return res.status(err.statusCode || 500).send(err)
    }
    if(!cb) {
      return res.send(body)
    }
    cb(res, body)
  })
}

router.post('/kubernetes/', (req, res) => {
  const { getK8sPaths, getK8sConfig, postK8sResource } = k8sClient
  const calls = [getK8sPaths, getK8sConfig, postK8sResource]
  async.waterfall([async.constant(req), ...calls], (err, result) => {
    if (err) {
      if (err.message) {
        const resource = _.get(req, 'body.metadata.name')
        const msg = `${resource} on local-cluster : failed to handle Create action with err: ${err.message.replace(/\r?\n|\r/, '')}`
        return res.json({
          error : {
            statusCode: err.statusCode || 500,
            message: msg
          }
        })
      } else {
        return res.status(err.statusCode || 500).end()
      }
    }

    res.set('Content-Type', 'application/json')
    res.send(result)
  })
})

router.get(`/kubernetes${ACTION_API_URL}/namespaces/:namespace/managedclusteractions`, (req, res) => get(req, res))
router.post(`/kubernetes${ACTION_API_URL}/namespaces/:namespace/managedclusteractions`, (req, res) => post(req, res))

module.exports = router
