/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2017, 2019. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
'use strict'

const express = require('express'),
      router = express.Router(),
      uiConfigClient = require('../../lib/server/uiconfig-client')

router.get('*', (req, res) => {
  uiConfigClient.getUiConfig(req, (err, body) => {
    if (err) {
      res.statusMessage = err.message || res.statusMessage
      return res.sendStatus(500)
    }
    if (process.env.NODE_ENV === 'production') {
      const version = body.uiConfiguration.version || 'latest'
      const edition = body.uiConfiguration.edition || 'Community Edition'
      return res.json({ version: `${version} ${edition}` })
    }
    return res.json({ version: 'Dev edition' }) // For local dev env only
  })
})

module.exports = router
