/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2018. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************
/* Copyright (c) 2020 Red Hat, Inc. */
'use strict'

import resources from '../lib/shared/resources'
import { WelcomeStatic } from '../src-web/containers/WelcomeStatic'

const express = require('express')
const router = express.Router(),
      appUtil = require('../lib/server/app-util'),
      Provider = require('react-redux').Provider,
      StaticRouter = require('react-router-dom').StaticRouter,
      ReactDOMServer = require('react-dom/server'),
      React = require('react'),
      thunkMiddleware = require('redux-thunk').default,
      redux = require('redux'),
      context = require('../lib/shared/context'),
      config = require('../config'),
      headerClient = require('../lib/server/header-client'),
      manifestCSShelper = require('../lib/shared/manifestCSShelper')

resources(() => {
  require('../scss/welcome.scss')
})

let reducers
if(reducers === undefined) {
  reducers = require('../src-web/reducers')
}

const store = redux.createStore(
  redux.combineReducers(reducers),
  redux.applyMiddleware(thunkMiddleware) /*lets us dispatch() functions*/
)

router.get('*', (req, res) => {
  const contextTemp = getContext(req)

  headerClient.getHeader(req, (err, response) => {
    if (err) {
      return res.send(err)
    }
    const { headerHtml: header, props: propsH, state: stateH, files: filesH } = response
    const manifest = manifestCSShelper(appUtil.app().locals.manifest, 1)
    try {
      res.render('home', Object.assign({
        manifest,
        content: ReactDOMServer.renderToString(
          <Provider store={store}>
            <StaticRouter
              location={req.originalUrl}
              context={contextTemp}>
              <WelcomeStatic></WelcomeStatic>
            </StaticRouter>
          </Provider>
        ),
        headerContextPath: config.get('headerContextPath'),
        state: store.getState(),
        props: contextTemp,
        header: header,
        propsH: propsH,
        stateH: stateH,
        filesH: filesH
      }, contextTemp))
    } catch (err) {
      // eslint-disable-next-line no-console
      console.error('Error rendering welcome page: ', err)
      return res.send(err)
    }
  })
})

function getContext(req) {
  const reqContext = context(req)
  return {
    title: 'Red Hat Advanced Cluster Management for Kubernetes',
    context: reqContext
  }
}

module.exports = router
