/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2019. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
/* Copyright (c) 2020 Red Hat, Inc. */

const tapReporter = [
  'jest-tap-reporter',
  {
    logLevel: 'ERROR',
    showInternalStackTraces: true,
    filePath: 'test-output/unit/jestTestLogs.tap'
  }
]

const jestConfig = {
  testURL: 'http://localhost:3000/header/',
  collectCoverage: true,
  collectCoverageFrom: [
    '<rootDir>/controllers/**/*.js',
    '<rootDir>/lib/**/*.js',
    '<rootDir>/templates/helpers/*.js',
    '<rootDir>/src-web/**/*.js',
  ],
  coveragePathIgnorePatterns: [
    '/node_modules/',
    '<rootDir>/tests/jest/config/'
  ],
  coverageDirectory: './test-output/unit/coverage',
  coverageReporters: [
    'json-summary',
    'json',
    'html',
    'lcov',
    'text',
    'text-summary'
  ],
  testResultsProcessor: 'jest-sonar-reporter',
  coverageThreshold: {
    global: {
      branches: 1,
      functions: 1,
      lines: 1,
      statements: 1,
    },
  },
  transform: {
    '^.+\\.js$': 'babel-jest',
    '.+\\.(hbs)$': 'jest-handlebars',
    '.+\\.(handlebars)$': 'jest-handlebars',
  },
  testMatch: [
    '<rootDir>/tests/jest/*.js?(x)',
    '<rootDir>/tests/jest/*-tests/*.js?(x)',
    '<rootDir>/tests/jest/*-tests/*-tests/*.js?(x)'
  ],
  setupFiles: [
    '<rootDir>/tests/jest/config/shim.js',
    '<rootDir>/tests/jest/config/setup.js'
  ],
  transformIgnorePatterns: ['/node_modules/(?!monaco-editor).+\\.js$'],
  moduleNameMapper: {
    '\\.(css|scss)$': '<rootDir>/tests/jest/config/styleMock.js'
  },
  globals: {
    'CONSOLE_CONTEXT_URL': '/header'
  },
}

jestConfig.reporters = process.env.TRAVIS ? [ 'default', tapReporter ] : [ 'default']

module.exports = jestConfig
