/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2018, 2019. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
/* Copyright (c) 2020 Red Hat, Inc. */
'use strict'

import http from './http-util'

const headerContextPath = http.getContextRoot()
const PLATFORM_API_PATH = `${headerContextPath}/api`
const CLUSTERS_PATH = `${PLATFORM_API_PATH}/v1/clusters`

const DEFAULT_OPTIONS = {
  credentials: 'same-origin',
  headers: {}
}

class PlatformApiClient {

  getManagedClusters(successCB, errorCB) {
    const url = CLUSTERS_PATH
    http.fetch(url, successCB, errorCB, DEFAULT_OPTIONS)
  }
}

export default new PlatformApiClient()
