/* Copyright (c) 2020 Red Hat, Inc. */
'use strict'

const request = require('./request'),
      config = require('../../config'),
      // httpUtil = require('../server/http-util'),
      serviceAccount = require('./service-account'),
      log4js = require('log4js'),
      fs = require('fs'),
      logger = log4js.getLogger('namespace-client'),
      serviceAccountPath = '/var/run/secrets/kubernetes.io/serviceaccount'

exports.getACMVersion = (req, cb) => {
  const acmAPI = '/apis/operator.open-cluster-management.io/v1'
  let namespace = 'open-cluster-management'
  try {
    if(process.env.NODE_ENV === 'production'){
      namespace = fs.readFileSync(`${serviceAccountPath}/namespace`, 'utf8')
    }
  } catch (err) {
    logger.error('Error reading service account namespace', err && err.message)
  }
  const mchPath = `/namespaces/${namespace}/multiclusterhubs/multiclusterhub`
  const options = {
    method: 'GET',
    url: `${config.get('API_SERVER_URL')}${acmAPI}${mchPath}`,
    json: true,
    headers: {
      // Cookie: httpUtil.getAuth(),
      'Content-Type': 'application/json',
      'Accept': 'application/json',
      Authorization: `Bearer ${serviceAccount.getServiceCredentials()}`
    },
  }

  request(options, null, [200], (err, res) => {
    if (err) {
      return cb(err, null)
    }
    cb(null, res)
  }, logger)

}
