/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2020. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************
 /* Copyright (c) 2020 Red Hat, Inc. */

'use strict'

const _ = require('lodash'),
      config = require('../../config'),
      cookieUtil = require('./cookie-util'),
      request = require('./request'),
      log4js = require('log4js'),
      logger = log4js.getLogger('application-client')

const applicationJSONStr = 'application/json'

exports.getOpenshiftConsoleURL = (req, cb) => {
  const options = {
    url: `${config.get('API_SERVER_URL')}/api/v1/namespaces/openshift-config-managed/configmaps/console-public`,
    headers: {
      'Content-Type': applicationJSONStr,
      'Accept': applicationJSONStr,
      'Authorization': req.headers.Authorization || req.headers.authorization || `Bearer ${cookieUtil.getAccessToken(req)}`
    },
    json: true
  }

  request(options, null, [200, 201, 204], (err, response) => {
    if (err) {
      return cb(err, null)
    }
    const openshiftConsoleURL = _.get(response, 'body.data.consoleURL', null)
    cb(err, {
      url: openshiftConsoleURL,
      name: 'Red Hat OpenShift Container Platform',
      icon: `${config.get('headerContextPath')}/graphics/openshift.svg`
    })
  }, logger)
}

exports.getConsoleLinks = (req, cb) => {
  const options = {
    url: `${config.get('API_SERVER_URL')}/apis/console.openshift.io/v1/consolelinks`,
    headers: {
      'Content-Type': applicationJSONStr,
      'Accept': applicationJSONStr,
      'Authorization': req.headers.Authorization || req.headers.authorization || `Bearer ${cookieUtil.getAccessToken(req)}`
    },
    json: true
  }

  request(options, null, [200, 201, 204], (err, response) => {
    if (err) {
      return cb(err, null)
    }
    const consoleLinks = _.get(response, 'body.items', null)
    const formattedLinks = consoleLinks
      ? consoleLinks.filter(link =>
        link.spec.location === 'ApplicationMenu'
        && link.spec.text !== 'Red Hat Advanced Cluster Management for Kubernetes')
        .map(link => ({
          url: link.spec.href,
          name: link.spec.text,
          icon: _.get(link, 'spec.applicationMenu.imageURL')
        }))
      : undefined
    cb(err, formattedLinks)
  }, logger)
}
