/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2017, 2019. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
/* Copyright (c) 2020 Red Hat, Inc. */
'use strict'

const config = require('../../config'),
      cookieUtil = require('./cookie-util'),
      request = require('./request'),
      _ = require('lodash'),
      async = require('async')

const appJsonStr = 'application/json'
exports.getManagedClusters = (req, cb) => {
  const options = {
    url: `${config.get('API_SERVER_URL')}/apis/project.openshift.io/v1/projects`,
    headers: {
      'Content-Type': appJsonStr,
      'Accept': appJsonStr,
      'Authorization': req.headers.Authorization || req.headers.authorization || `Bearer ${cookieUtil.getAccessToken(req)}`
    },
    json: true
  }

  request(options, null, [200, 201, 204], (err, response) => {
    if (err) {
      return cb(err, null)
    }
    const clusterNSs = []
    _.get(response, 'body.items',[]).map(item => {
      const labels = _.get(item, 'metadata.labels', [])
      const keys = Object.keys(labels)
      if (keys.includes('cluster.open-cluster-management.io/managedCluster')){
        clusterNSs.push(labels['cluster.open-cluster-management.io/managedCluster'])
      }
    })
    const managedClusterCalls = clusterNSs.map(clusterNS => {
      const getManagedCluster = (mcReq, name, mcCb) => {
        const mcOptions = {
          url: `${config.get('API_SERVER_URL')}/apis/cluster.open-cluster-management.io/v1/managedclusters/${name}`,
          headers: {
            'Content-Type': appJsonStr,
            'Accept': appJsonStr,
            'Authorization': mcReq.headers.Authorization || mcReq.headers.authorization || `Bearer ${cookieUtil.getAccessToken(mcReq)}`
          },
          json: true
        }
        request(mcOptions, null, [200, 201, 204, 404], (mcErr, mccResponse) => {
          if (_.get(mccResponse, 'body.code') === 404) {
            // Do not throw an error if the managed cluster info resource is not found
            return mcCb(null, null)
          }
          if (mcErr) {
            return mcCb(mcErr, null)
          }
          return mcCb(mcErr, mccResponse.body)
        })
      }
      return getManagedCluster.bind(this, req, clusterNS)
    })
    async.parallel(managedClusterCalls, (mccErr, results) => {
      cb(mccErr, results)
    })
  })
}
