/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2017, 2018. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
/* Copyright (c) 2020 Red Hat, Inc. */
'use strict'
const constants = require('../shared/constants'),
      cookie = require('cookie')

exports.getUser = function(userCookie) {
  if (userCookie) {
    const buffer = new Buffer(userCookie, 'base64')
    try {
      return JSON.parse(buffer.toString())
    } catch (e) {
      return false
    }
  }
  return undefined
}

exports.isLoggedIn = function(req) {
  return !!exports.getAccessToken(req) && !!exports.getAuthToken(req)
}

exports.getAccessToken = function(req) {
  return req.cookies[constants.ACM_ACCESS_COOKIE]
}

exports.getAuthToken = function(req) {
  return req.cookies[constants.CFC_AUTH_COOKIE]
}

exports.parseCookies = function(cookies) {
  return cookies && cookies.map(resCookie => cookie.parse(resCookie))
}

exports.getCookie = function(parsedCookies, cookieName) {
  return parsedCookies && parsedCookies.filter(parsedCookie => !!parsedCookie[cookieName])
}

exports.deleteAuthCookies = function(res) {
  res.clearCookie(constants.ACM_ACCESS_COOKIE)
  res.clearCookie(constants.CFC_AUTH_COOKIE)
  res.clearCookie(constants.JSESSIONID)
  res.clearCookie(constants.CFC_REDIRECT_COOKIE)
  res.clearCookie(constants.WAS_COOKIE)
  return res
}

exports.getXsrfToken = () => {
  const token = document.getElementById('headerAccess') ? document.getElementById('headerAccess').value : ''
  return token.toString('ascii')
}
