/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2019. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
/* Copyright (c) 2020, 2021 Red Hat, Inc. */
'use strict'

import msgs from '../../nls/platform.properties'

exports.getDefaultConfig = (locale) => {
  return {
    header: {
      logoUrl: '/multicloud/header/graphics/RHACM-Logo.svg',
      logoAltText: 'Red Hat Advanced Cluster Management for Kubernetes',
      docUrlMapping: 'https://access.redhat.com/documentation/en-us/red_hat_advanced_cluster_management_for_kubernetes/2.2/',
      supportUrl: 'https://ibm.biz/icpsupport',
    },
    about: {
      logoAltText: 'Red Hat Advanced Cluster Management for Kubernetes',
      copyright: 'Copyright © 2020 IBM Corporation. All rights reserved. \nCopyright © 2020 Red Hat, Inc. All rights reserved.',
      version: '1.0.0',
    },
    navItems: [
      {
        id: 'home',
        label: msgs.get('navitems.home', locale),
        url: '/multicloud/welcome',
        serviceId: 'webui-nav',
      },
      {
        id: 'observe',
        label: msgs.get('navitems.observe', locale),
        url: '/overview',
      },
      {
        id: 'overview',
        label: msgs.get('navitems.overview', locale),
        url: '/overview',
        parentId: 'observe',
        serviceId: 'search-ui',
      },
      {
        id: 'automate',
        label: msgs.get('navitems.automate', locale),
      },
      {
        id: 'clusters',
        label: msgs.get('navitems.clusters', locale),
        url: '/multicloud/clusters',
        serviceId: 'console',
        parentId: 'automate',
      },
      {
        id: 'bare-metal-assets',
        label: msgs.get('navitems.baremetalassets', locale),
        url: '/multicloud/bare-metal-assets',
        serviceId: 'console',
        parentId: 'automate',
      },
      {
        id: 'applications',
        label: msgs.get('navitems.applications', locale),
        url: '/multicloud/applications',
        serviceId: 'app-ui',
        disabled: true
      },
      {
        id: 'grc',
        label: msgs.get('navitems.grc', locale),
        url: '/multicloud/policies',
        serviceId: 'grc-ui',
      },
    ]
  }
}
