/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2019. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
/* Copyright (c) 2020 Red Hat, Inc. */
'use strict'

const request = require('./request'),
      cookieUtil = require('./cookie-util')

exports.graphqlService = (req, cb) => {
  const options = {
    method: 'POST',
    url: '/multicloud/header/graphql',
    json: req.body,
    headers: {
      'Content-Type': 'application/json',
      Cookie: req.headers.cookie,
      'XSRF-Token': cookieUtil.getXsrfToken(),
    },
  }
  options.headers.Authorization =
    req.headers.Authorization ||
    req.headers.authorization ||
    `Bearer ${cookieUtil.getAccessToken(req)}`

  request(options, null, [200], (err, res) => {
    if (err) {
      return cb(err, null)
    }
    cb(err, res)
  })
}
