/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2019. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
/* Copyright (c) 2020 Red Hat, Inc. */
'use strict'

const request = require('./request'),
      config = require('../../config'),
      httpUtil = require('../server/http-util'),
      cookieUtil = require('./cookie-util'),
      i18n = require('node-i18n-util')


exports.getHeader = (req, cb) => {
  const options = process.env.NODE_ENV ==='development'
    ? httpUtil.getOptions(
      req,
      `https://localhost:3000${process.env.headerContextPath || '/multicloud/header'}/api/v1/header?serviceId=webui-nav&dev=${process.env.NODE_ENV === 'development'}`
    )
    : httpUtil.getOptions(
      req,
      `${config.get('headerUrl')}${process.env.headerContextPath || '/multicloud/header'}/api/v1/header?serviceId=platform-ui&dev=${process.env.NODE_ENV === 'development'}`
    )
  doRequest(req, options, cb)
}

exports.checkStatus = (req, cb) => {
  const options = httpUtil.getOptions(req, config.get('headerStatusEndpoint'))
  doRequest(req, options, cb)
}

function doRequest(req, options, cb) {
  options.json = true
  options.headers = {
    Authorization: req && req.headers &&
    ( req.headers.Authorization ||
      req.headers.authorization ||
      `Bearer ${cookieUtil.getAccessToken(req)}`
    ),
    Cookie: req.headers.cookie,
    'Accept-Language': i18n.locale(req)
  }
  request(options, null, [200, 201, 204], (err, res) => {
    if (err) {
      return cb(err, null)
    }
    cb(err, res.body)
  })
}
