/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2017, 2019. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
/* Copyright (c) 2020 Red Hat, Inc. */
'use strict'

const _ = require('lodash'),
      config = require('../../config'),
      cookieUtil = require('./cookie-util'),
      request = require('./request'),
      log4js = require('log4js'),
      logger = log4js.getLogger('namespace-client')


exports.getUserNamespaces = (req, cb) => {
  const options = {
    url: `${config.get('API_SERVER_URL')}/apis/project.openshift.io/v1/projects`,
    headers: {
      'Content-Type': 'application/json',
      'Accept': 'application/json',
      'Authorization': req.headers.Authorization || req.headers.authorization || `Bearer ${cookieUtil.getAccessToken(req)}`
    },
    json: true
  }

  request(options, null, [200, 201, 204], (err, response) => {
    if (err) {
      return cb(err, null)
    }

    let userNamespaces = _.get(response, 'body.items', null)
    userNamespaces = userNamespaces
      ? userNamespaces.map(item => ({ Name: item.metadata.name }))
      : []
    cb(err, userNamespaces)
  }, logger)
}
