/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2019. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
/* Copyright (c) 2020 Red Hat, Inc. */
'use strict'

const configParams = require('../shared/config'),
      _ = require('lodash'),
      { getDefaultConfig } = require('./default-nav')

//if running in dev, and the service id matches the route service id, using the router url, otherwise, it's relative
const getBaseUrl = (req, appServiceId, dev, routeServiceId) => {
  return JSON.parse(dev) === true && appServiceId !== routeServiceId ? configParams.API_SERVER_URL : ''
}

const externalUrlCheck = (appServiceId, routeServiceId) => {
  const supportedServices = ['platform-ui', 'mcm-ui']
  if (supportedServices.includes(appServiceId)) {
    return routeServiceId !== appServiceId
  }

  return true
}

exports.getConfig = (req, crName, dev, locale) => {
  //merge routes and config
  const config = {}
  let navItems = []
  const otherNav = {
    items:[]
  }
  let disableItems = []
  config.header = getDefaultConfig(locale).header
  config.about = getDefaultConfig(locale).about
  navItems = fashionItems(req, getDefaultConfig(locale).navItems, crName, dev)
  otherNav.items.push({id: 'defaultconfig', header: config.header, about: config.about, navItems: navItems})
  otherNav.items.forEach(item => {
    disableItems = _.get(item,'header.disabledItem','')
  })

  return {
    ...config,
    navItems: [...navItems],
    otherNav: [...otherNav.items],
    disableItems
  }

}

const fashionItems = (req, items, appServiceId, dev) => {
  let updatedItems = []
  const itemsWithParents = []
  //get all items
  const getUrl = getBaseUrl.bind(this, req, appServiceId, dev)
  items.length > 0 && items.map(item => {
    const updatedItem = {}
    //featureFlags_baremetal apply
    //if the item has some authorization
    //check for the user role in the list of auth
    //return if the role is in there
    // TODO need to figure out alternative to the ICP user role check
    if(/*(item && item.isAuthorized && item.isAuthorized.length > 0 && item.isAuthorized.includes(userRole)) || */ item && !item.isAuthorized){
      updatedItem.id = item.id
      updatedItem.label = item.label
      updatedItem.target = _.get(item, 'target', '')
      updatedItem.url = item.url && `${getUrl(item.serviceId)}${item.url}`
      updatedItem.iconUrl =  _.get(item, 'iconUrl', null)
      updatedItem.parentId = _.get(item, 'parentId', null)
      updatedItem.external = item.serviceId && externalUrlCheck(appServiceId, item.serviceId)
      // Do not show the bare-metal-asset nav link when disabled. Default behaviour
      if( !(configParams['featureFlags_baremetal'] === 'false' && item.id === 'bare-metal-assets') ) {
        updatedItem.parentId ? itemsWithParents.push(updatedItem) : updatedItems.push(updatedItem)
      }
    }
  })
  //updateNavitems with children
  updateParentItems(itemsWithParents, updatedItems)
  if (updatedItems.length > 0) {
    updatedItems = updatedItems.filter(item => {
      if(item.subItems && item.subItems.length > 0 || item.url) {
        return item
      }
      return undefined
    })
  }
  return updatedItems
}

const updateParentItems = (children, parentItems) => {
  children.map(item => {
    const parentId = item.parentId
    const ind = _.findIndex(parentItems, (pItem) => pItem.id === parentId)
    if(ind > -1 && parentItems[ind].subItems){
      parentItems[ind].subItems.push(item)
    } else if(ind > -1){
      parentItems[ind].subItems = []
      parentItems[ind].subItems.push(item)
    }
  })
}


exports.updateLeftNavConfig = (routes, navItem) => {
  //putting automatically discovered items in the administer menu item since design doesn't want them at the root
  const route = routes && routes.find(item => (item.id === navItem.route || item.id === 'administer'))

  if (!route) {
    return routes
  }

  const index = _.findIndex(route.subItems, item => item.id === navItem.id)

  navItem.enabled ?
    index === -1 && route.subItems.push({
      id: navItem.id,
      label: navItem.displayName,
      url: navItem.url,
      serviceId: navItem.chart,
      external: true,
      target: navItem.target,
    }) : index > -1 && route.subItems.splice(index, 1)
  return routes.map(item => {
    if (item.id === navItem.id) {
      item = route
    }
    return item
  })
}
