/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2017, 2019. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
/* Copyright (c) 2020 Red Hat, Inc. */
'use strict'

const fs = require('fs'),
      log4js = require('log4js'),
      logger = log4js.getLogger('service-account'),
      serviceAccountPath = '/var/run/secrets/kubernetes.io/serviceaccount'

let SERVICEACCT_TOKEN, KUBE_NS, CA_CERT

exports.getServiceCredentials = () => {
  if (SERVICEACCT_TOKEN) {
    return SERVICEACCT_TOKEN
  }

  try {
    if(process.env.NODE_ENV === 'production'){
      SERVICEACCT_TOKEN = fs.readFileSync(`${serviceAccountPath}/token`, 'utf8')
    } else {
      SERVICEACCT_TOKEN = process.env.SERVICEACCT_TOKEN || ''
    }
  } catch (err) {
    logger.error('Error reading service account token', err && err.message)
  }

  logger.debug(`SERVICEACCT_TOKEN=${SERVICEACCT_TOKEN}`)

  return SERVICEACCT_TOKEN
}

exports.getServiceAccountNamespace = () => {
  if (KUBE_NS) {
    return KUBE_NS
  }

  try {
    if(process.env.NODE_ENV === 'production'){
      KUBE_NS = fs.readFileSync(`${serviceAccountPath}/namespace`, 'utf8')
    } else{
      KUBE_NS = process.env.KUBE_NS || ''
    }
  } catch (err) {
    logger.error('Error reading service account namespace', err && err.message)
  }

  logger.debug(`KUBE_NS=${KUBE_NS}`)

  return KUBE_NS
}

exports.getCACert = () => {
  if (CA_CERT) {
    return CA_CERT
  }

  try {
    if(process.env.NODE_ENV === 'production'){
      CA_CERT = fs.readFileSync(`${serviceAccountPath}/ca.crt`, 'utf8')
    } else{
      CA_CERT = process.env.CA_CERT || ''
    }
  } catch (err) {
    logger.error('Error reading service account ca.crt', err && err.message)
  }

  logger.debug(`CA_CERT=${CA_CERT}`)

  return CA_CERT
}
