/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2018, 2019. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
/* Copyright (c) 2020 Red Hat, Inc. */
'use strict'

const _ = require('lodash'),
      k8sClient = require('./k8s-client'),
      log4js = require('log4js'),
      logger = log4js.getLogger('uiconfig-client')

exports.getUiConfig = (req, cb) => {
  k8sClient.getWithServiceCredentials('/apis/config.openshift.io/v1/infrastructures', (err, res) => {
    if (err) {
      logger.error(err)
    }

    const clusterInfo = _.get(res, 'items[0]')
    if (clusterInfo && clusterInfo.kind === 'Infrastructure') {
      cb(err, res)
    }
  })
}
