/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2017, 2018. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
/* Copyright (c) 2020 Red Hat, Inc. */
const requireServer = require('./require-server'),
      nconf = requireServer('nconf')

const WHITELIST = [
  'headerContextPath',
  'headerUrl',
  'API_SERVER_URL',
  'idleTime',
  'NAV_PORT',
  'httpPort',
  'featureFlags_baremetal',
  'featureFlags:liveUpdates',
  'featureFlags:liveUpdatesPollInterval',
  'featureFlags:axe',
  'featureFlags:reduxLogger',
  'featureFlags:wipModals',
  'featureFlags:serviceId',
  'featureFlags:enableSegment',
  'featureFlags:segmentKey'
]

let config = {}

if (nconf) {
  WHITELIST.forEach(i => config[i] = nconf.get(i))
  config.env = process.env.NODE_ENV
} else {
  const configElement = document.getElementById('config')
  config = (configElement && JSON.parse(configElement.textContent)) || {}
}

module.exports = config
