/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2017, 2019. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 * Copyright (c) 2020 Red Hat, Inc.
 *******************************************************************************/
/* Copyright (c) 2020 Red Hat, Inc. */
'use strict'

/*
 * A boolean module that is true on the client, false on the server. This is for code that needs to
 * do different things on the server vs the client.
 */

module.exports.ACM_ACCESS_COOKIE = 'acm-access-token-cookie'
module.exports.CFC_AUTH_COOKIE = 'cfc-acs-auth-cookie'
module.exports.CFC_REDIRECT_COOKIE = 'cfc-redirect-cookie'
module.exports.JSESSIONID = 'JSESSIONID'
module.exports.WAS_COOKIE = 'WAS_*'
module.exports.MAX_CHART_DATA_SIZE = 30
module.exports.ROKS_ID = 'roks'

const serviceApiVersionStr = 'servicecatalog.k8s.io/v1beta1'
const authApiVersionStr = 'rbac.authorization.k8s.io/v1'

module.exports.RESOURCE_TYPES = {
  //native k8s resource types
  CLUSTER_ROLE_BINDING: {
    name: 'ClusterRoleBinding',
    list: 'ClusterRoleBindingList',
    resource: 'clusterrolebindings',
    api_prefix: 'apis',
    api_version: authApiVersionStr
  },
  CONFIG_MAP: {
    name: 'ConfigMap',
    list: 'ConfigMapList',
    resource: 'configmaps',
    resource_short: 'cm',
    api_prefix: 'api',
    api_version: 'v1'
  },
  CRON_JOB: {
    name: 'CronJob',
    list: 'CronJobList',
    resource: 'cronjobs',
    api_prefix: 'apis',
    api_version: 'batch/v1beta1'
  },
  DEPLOYMENT: {
    name: 'Deployment',
    list: 'DeploymentList',
    resource: 'deployments',
    resource_short: 'deploy',
    api_prefix: 'apis',
    api_version: 'apps/v1'
  },
  DAEMON_SET: {
    name: 'DaemonSet',
    list: 'DaemonSetList',
    resource: 'daemonsets',
    resource_short: 'ds',
    api_prefix: 'apis',
    api_version: 'apps/v1'
  },
  HORIZONTAL_POD_AUTOSCALER: {
    name: 'HorizontalPodAutoscaler',
    list: 'HorizontalPodAutoscalerList',
    resource: 'horizontalpodautoscalers',
    resource_short: 'hpa',
    api_prefix: 'apis',
    api_version: 'autoscaling/v1'
  },
  INGRESS: {
    name: 'Ingress',
    list: 'IngressList',
    resource: 'ingresses',
    resource_short: 'ing',
    api_prefix: 'apis',
    api_version: 'extensions/v1beta1'
  },
  JOB: {
    name: 'Job',
    list: 'JobList',
    resource: 'jobs',
    api_prefix: 'apis',
    api_version: 'batch/v1'
  },
  NAMESPACE: {
    name: 'Namespace',
    list: 'NamespaceList',
    resource: 'namespaces',
    resource_short: 'ns',
    api_prefix: 'api',
    api_version: 'v1'
  },
  NETWORK_POLICY: {
    name: 'NetworkPolicy',
    list: 'NetworkPolicyList',
    resource: 'networkpolicies',
    resource_short: 'netpol',
    api_prefix: 'apis',
    api_version: 'networking.k8s.io/v1'
  },
  NODE: { name: 'Node', list: 'NodeList', resource: 'nodes', resource_short: 'no' },
  PERSISTENT_VOLUME_CLAIM: {
    name: 'PersistentVolumeClaim',
    list: 'PersistentVolumeClaimList',
    resource: 'persistentvolumeclaims',
    resource_short: 'pvc',
    api_prefix: 'api',
    api_version: 'v1'
  },
  PERSISTENT_VOLUME: {
    name: 'PersistentVolume',
    list: 'PersistentVolumeList',
    resource: 'persistentvolumes',
    resource_short: 'pv',
    api_prefix: 'api',
    api_version: 'v1'
  },
  POD_SECURITY_POLICY: {
    name: 'PodSecurityPolicy',
    list: 'PodSecurityPolicyList',
    resource: 'podsecuritypolicies',
    resource_short: 'psp',
    api_prefix: 'apis',
    api_version: 'extensions/v1beta1'
  },
  RESOURCE_QUOTA: {
    name: 'ResourceQuota',
    list: 'ResourceQuotaList',
    resource: 'resourcequotas',
    resource_short: 'quota',
    api_prefix: 'api',
    api_version: 'v1'
  },
  SECRET: {
    name: 'Secret',
    list: 'SecretList',
    resource: 'secrets',
    api_prefix: 'api',
    api_version: 'v1'
  },
  SERVICE: {
    name: 'Service',
    list: 'ServiceList',
    resource: 'services',
    resource_short: 'svc',
    api_prefix: 'api',
    api_version: 'v1'
  },
  SERVICE_ACCOUNT: {
    name: 'ServiceAccount',
    list: 'ServiceAccountList',
    resource: 'serviceaccounts',
    api_prefix: 'api',
    api_version: 'v1'
  },
  STATEFUL_SET: {
    name: 'StatefulSet',
    list: 'StatefulSetList',
    resource: 'statefulsets',
    api_prefix: 'apis',
    api_version: 'apps/v1'
  },
  REPLICA_SET: {
    name: 'ReplicaSet',
    list: 'ReplicaSetList',
    resource: 'replicasets',
    resource_short: 'rs',
    api_prefix: 'apis',
    api_version: 'apps/v1'
  },
  RESOURCES: { name: 'Resources' },
  ROLE: {
    name: 'Role',
    list: 'RoleList',
    resource: 'roles',
    api_prefix: 'apis',
    api_version: authApiVersionStr
  },
  ROLE_BINDING: {
    name: 'RoleBinding',
    list: 'RoleBindingList',
    resource: 'rolebindings',
    api_prefix: 'apis',
    api_version: authApiVersionStr
  },
  POD: {
    name: 'Pod',
    list: 'PodList',
    resource: 'pods',
    api_prefix: 'api',
    api_version: 'v1'
  },
  CONTAINER: { name: 'Container', list: 'ContainerList' },
  EVENT: {
    name: 'Event',
    list: 'EventList',
    api_prefix: 'api',
    api_version: 'v1'
  },
  CLUSTER_SERVICE_BROKER: {
    name: 'ClusterServiceBroker',
    list: 'ClusterServiceBrokerList',
    resource: 'clusterservicebrokers',
    api_prefix: 'apis',
    api_version: serviceApiVersionStr
  },
  CLUSTER_SERVICE_CLASS: {
    name: 'ClusterServiceClass',
    list: 'ClusterServiceClassList',
    resource: 'clusterserviceclasses',
    api_prefix: 'apis',
    api_version: serviceApiVersionStr
  },
  CLUSTER_SERVICE_PLAN: {
    name: 'ClusterServicePlan',
    list: 'ClusterServicePlanList',
    resource: 'clusterserviceplans',
    api_prefix: 'apis',
    api_version: serviceApiVersionStr },
  SERVICE_INSTANCE: {
    name: 'ServiceInstance',
    list: 'ServiceInstanceList',
    resource: 'serviceinstances',
    api_prefix: 'apis',
    api_version: serviceApiVersionStr
  },
  SERVICE_BINDING: {
    name: 'ServiceBinding',
    list: 'ServiceBindingList',
    resource: 'servicebindings',
    api_prefix: 'apis',
    api_version: serviceApiVersionStr
  },
  SERVICE_PLAN: {
    name: 'ServicePlan',
    list: 'ServicePlanList',
    resource: 'serviceplans',
    api_prefix: 'apis',
    api_version: serviceApiVersionStr
  },

  // multi-resource types
  IMAGE_POLICIES: {
    name: 'ImagePolicies',
    list: 'ImagePolicyList',
    api_prefix: 'api',
    api_version: 'v1',
    resource: 'imagepolicies',
    resources: ['CLUSTER_IMAGE_POLICY', 'IMAGE_POLICY']
  },
  CLUSTER_IMAGE_POLICY: {
    name: 'ClusterImagePolicy',
    list: 'ImagePolicyList',
    resource: 'clusterimagepolicies',
    api_prefix: 'apis',
    api_version: 'securityenforcement.admission.cloud.ibm.com/v1beta1'
  },
  IMAGE_POLICY: {
    name: 'ImagePolicy',
    list: 'ImagePolicyList',
    resource: 'imagepolicies',
    api_prefix: 'apis',
    api_version: 'securityenforcement.admission.cloud.ibm.com/v1beta1'
  },

  //other resource types
  VA: { name: 'VA', list: 'VAList' },
  IMAGE: { name: 'Image', list: 'ImageList', resource: 'images' },

  //iam resource types
  SERVICE_ID: { name: 'ServiceId', list: 'ServiceIdList', resource: 'serviceids', type: 'iam' },
  API_KEY: { name: 'ApiKey', list: 'ApiKeyList', resource: 'apikeys', type: 'iam' },
  SERVICE_POLICY: { name: 'ServicePolicy', list: 'ServicePolicyList', resource: 'policies', type: 'iam' },

  //user mgmt resource types
  LDAP: { name: 'ldap', type: 'userMgmt', list: 'ldap' },
  LDAP_MEMBERS: { name: 'ldapMembers', type: 'userMgmt' },
  LDAP_USERGROUPS: { name: 'ldapUsergroups', resource_short: 'Usergroups', type: 'userMgmt' },
  LDAP_USERS: { name: 'ldapUsers', resource_short: 'Users', type: 'userMgmt' },
  SERVICEIDS_FOR_TEAM: { name: 'ServiceIdsForTeam', list: 'ServiceIdsForTeamList', type: 'userMgmt', resource: 'teams' },
  TEAM: { name: 'Team', list: 'TeamList', type: 'userMgmt' },
  TEAM_RESOURCE: { name: 'TeamResource', list: 'TeamResourceList', type: 'userMgmt' },
  TEAM_USER: { name: 'TeamUser', list: 'TeamUserList', type: 'userMgmt' },
  TEAM_USERGROUP: { name: 'TeamUsergroup', list: 'TeamUsergroupList', type: 'userMgmt' },
  TEAMS_FOR_SERVICEID: { name: 'TeamsForServiceId', list: 'TeamsForServiceIdList', type: 'userMgmt', resource: 'teams' },
  USER: { name: 'User', list: 'UserList', type: 'userMgmt' },
  USER_TEAM: { name: 'UserTeam', list: 'UserTeamList', type: 'userMgmt' },
  USER_RESOURCE: { name: 'UserResource', type: 'userMgmt', list: 'UserResourceList' },
  USER_TEAM_COUNT: { name: 'userTeamCount', type: 'userMgmt' }
}

const DOC_BASE_PATH = 'https://www.ibm.com/support/knowledgecenter'
const DOC_COLLECTION_NUMBER = 'SSFC4F_1.2.0'

module.exports.DOCUMENTATION_LINKS = {
  INSTALL_CLI: `${DOC_BASE_PATH}/${DOC_COLLECTION_NUMBER}/cloudctl/icp_cli.html`,
  CLI_COMMANDS: `${DOC_BASE_PATH}/${DOC_COLLECTION_NUMBER}/manage_cluster/cli_commands.html`,
  TRANSFORMATION_ADVISOR: `${DOC_BASE_PATH}/${DOC_COLLECTION_NUMBER}/featured_applications/transformation_advisor.html`,
  MICROCLIMATE: `${DOC_BASE_PATH}/${DOC_COLLECTION_NUMBER}/featured_applications/microclimate.html`,
  KUBECTL_CLI: `${DOC_BASE_PATH}/${DOC_COLLECTION_NUMBER}/cloudctl/install_kubectl.html`,
  CALICOCTL_CLI: `${DOC_BASE_PATH}/${DOC_COLLECTION_NUMBER}/cloudctl/install_istioctl.html`,
  ISTIOCTL_CLI: `${DOC_BASE_PATH}/${DOC_COLLECTION_NUMBER}/cloudctl/calicoctl.html`
}

// keep order from lowest to highest role
module.exports.ROLES = {
  VIEWER: 'Viewer',
  EDITOR: 'Editor',
  OPERATOR: 'Operator',
  ADMIN: 'Administrator',
  CLUSTER_ADMIN: 'ClusterAdministrator',
  ACCOUNT_ADMIN: 'AccountAdministrator'
}

module.exports.FILTER_TYPES = {
  ALL: 'all',
  SELECTED: 'selected'
}

module.exports.ACTION_STATUS = {
  FAILED: 'Failed',
  COMPLETED: 'Completed',
  ACTIVE: 'Active'
}

module.exports.TOAST = {
  SUCCESS: 'success',
  ERROR: 'error',
  WARNING: 'warning',
  INFO: 'info'
}

module.exports.TAB = {
  ACCOUNT_ADMIN: [ 'users', 'resources' ],
}
